/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.geometry.PxGeometry;

public class PxCapsuleGeometry
extends PxGeometry {
    public static final int SIZEOF = PxCapsuleGeometry.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxCapsuleGeometry() {
    }

    private static native int __sizeOf();

    public static PxCapsuleGeometry wrapPointer(long address) {
        return address != 0L ? new PxCapsuleGeometry(address) : null;
    }

    public static PxCapsuleGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCapsuleGeometry.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCapsuleGeometry(long address) {
        super(address);
    }

    public static PxCapsuleGeometry createAt(long address, float radius, float halfHeight) {
        Raw.PxCapsuleGeometry_placed(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = PxCapsuleGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxCapsuleGeometry createAt(T allocator, NativeObject.Allocator<T> allocate, float radius, float halfHeight) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxCapsuleGeometry_placed(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = PxCapsuleGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxCapsuleGeometry(float radius, float halfHeight) {
        this.address = Raw.PxCapsuleGeometry(radius, halfHeight);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getRadius() {
        this.checkNotNull();
        return Raw.getRadius(this.address);
    }

    public void setRadius(float value) {
        this.checkNotNull();
        Raw.setRadius(this.address, value);
    }

    public float getHalfHeight() {
        this.checkNotNull();
        return Raw.getHalfHeight(this.address);
    }

    public void setHalfHeight(float value) {
        this.checkNotNull();
        Raw.setHalfHeight(this.address, value);
    }

    public static class Raw {
        public static native void PxCapsuleGeometry_placed(long var0, float var2, float var3);

        public static native long PxCapsuleGeometry(float var0, float var1);

        public static native void destroy(long var0);

        public static native float getRadius(long var0);

        public static native void setRadius(long var0, float var2);

        public static native float getHalfHeight(long var0);

        public static native void setHalfHeight(long var0, float var2);
    }
}

