/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidBody;

public class PxRigidBodyExt
extends NativeObject {
    public static final int SIZEOF = PxRigidBodyExt.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRigidBodyExt() {
    }

    private static native int __sizeOf();

    public static PxRigidBodyExt wrapPointer(long address) {
        return address != 0L ? new PxRigidBodyExt(address) : null;
    }

    public static PxRigidBodyExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRigidBodyExt.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRigidBodyExt(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static boolean updateMassAndInertia(PxRigidBody body, float density) {
        return Raw.updateMassAndInertia(body.getAddress(), density);
    }

    public static boolean updateMassAndInertia(PxRigidBody body, float density, PxVec3 massLocalPose) {
        return Raw.updateMassAndInertia(body.getAddress(), density, massLocalPose.getAddress());
    }

    public static boolean updateMassAndInertia(PxRigidBody body, float density, PxVec3 massLocalPose, boolean includeNonSimShapes) {
        return Raw.updateMassAndInertia(body.getAddress(), density, massLocalPose.getAddress(), includeNonSimShapes);
    }

    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass) {
        return Raw.setMassAndUpdateInertia(body.getAddress(), mass);
    }

    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass, PxVec3 massLocalPose) {
        return Raw.setMassAndUpdateInertia(body.getAddress(), mass, massLocalPose.getAddress());
    }

    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass, PxVec3 massLocalPose, boolean includeNonSimShapes) {
        return Raw.setMassAndUpdateInertia(body.getAddress(), mass, massLocalPose.getAddress(), includeNonSimShapes);
    }

    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        Raw.addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }

    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode) {
        Raw.addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value);
    }

    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode, boolean wakeup) {
        Raw.addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value, wakeup);
    }

    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        Raw.addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }

    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode) {
        Raw.addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value);
    }

    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode, boolean wakeup) {
        Raw.addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value, wakeup);
    }

    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        Raw.addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }

    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode) {
        Raw.addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value);
    }

    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode, boolean wakeup) {
        Raw.addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value, wakeup);
    }

    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        Raw.addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }

    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode) {
        Raw.addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value);
    }

    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, PxForceModeEnum mode, boolean wakeup) {
        Raw.addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode.value, wakeup);
    }

    public static PxVec3 getVelocityAtPos(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(Raw.getVelocityAtPos(body.getAddress(), pos.getAddress()));
    }

    public static PxVec3 getLocalVelocityAtLocalPos(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(Raw.getLocalVelocityAtLocalPos(body.getAddress(), pos.getAddress()));
    }

    public static PxVec3 getVelocityAtOffset(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(Raw.getVelocityAtOffset(body.getAddress(), pos.getAddress()));
    }

    public static void computeVelocityDeltaFromImpulse(PxRigidBody body, PxVec3 impulsiveForce, PxVec3 impulsiveTorque, PxVec3 deltaLinearVelocity, PxVec3 deltaAngularVelocity) {
        Raw.computeVelocityDeltaFromImpulse(body.getAddress(), impulsiveForce.getAddress(), impulsiveTorque.getAddress(), deltaLinearVelocity.getAddress(), deltaAngularVelocity.getAddress());
    }

    public static void computeVelocityDeltaFromImpulse(PxRigidBody body, PxTransform globalPose, PxVec3 point, PxVec3 impulse, float invMassScale, float invInertiaScale, PxVec3 deltaLinearVelocity, PxVec3 deltaAngularVelocity) {
        Raw.computeVelocityDeltaFromImpulse(body.getAddress(), globalPose.getAddress(), point.getAddress(), impulse.getAddress(), invMassScale, invInertiaScale, deltaLinearVelocity.getAddress(), deltaAngularVelocity.getAddress());
    }

    public static void computeLinearAngularImpulse(PxRigidBody body, PxTransform globalPose, PxVec3 point, PxVec3 impulse, float invMassScale, float invInertiaScale, PxVec3 linearImpulse, PxVec3 angularImpulse) {
        Raw.computeLinearAngularImpulse(body.getAddress(), globalPose.getAddress(), point.getAddress(), impulse.getAddress(), invMassScale, invInertiaScale, linearImpulse.getAddress(), angularImpulse.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native boolean updateMassAndInertia(long var0, float var2);

        public static native boolean updateMassAndInertia(long var0, float var2, long var3);

        public static native boolean updateMassAndInertia(long var0, float var2, long var3, boolean var5);

        public static native boolean setMassAndUpdateInertia(long var0, float var2);

        public static native boolean setMassAndUpdateInertia(long var0, float var2, long var3);

        public static native boolean setMassAndUpdateInertia(long var0, float var2, long var3, boolean var5);

        public static native void addForceAtPos(long var0, long var2, long var4);

        public static native void addForceAtPos(long var0, long var2, long var4, int var6);

        public static native void addForceAtPos(long var0, long var2, long var4, int var6, boolean var7);

        public static native void addForceAtLocalPos(long var0, long var2, long var4);

        public static native void addForceAtLocalPos(long var0, long var2, long var4, int var6);

        public static native void addForceAtLocalPos(long var0, long var2, long var4, int var6, boolean var7);

        public static native void addLocalForceAtPos(long var0, long var2, long var4);

        public static native void addLocalForceAtPos(long var0, long var2, long var4, int var6);

        public static native void addLocalForceAtPos(long var0, long var2, long var4, int var6, boolean var7);

        public static native void addLocalForceAtLocalPos(long var0, long var2, long var4);

        public static native void addLocalForceAtLocalPos(long var0, long var2, long var4, int var6);

        public static native void addLocalForceAtLocalPos(long var0, long var2, long var4, int var6, boolean var7);

        public static native long getVelocityAtPos(long var0, long var2);

        public static native long getLocalVelocityAtLocalPos(long var0, long var2);

        public static native long getVelocityAtOffset(long var0, long var2);

        public static native void computeVelocityDeltaFromImpulse(long var0, long var2, long var4, long var6, long var8);

        public static native void computeVelocityDeltaFromImpulse(long var0, long var2, long var4, long var6, float var8, float var9, long var10, long var12);

        public static native void computeLinearAngularImpulse(long var0, long var2, long var4, long var6, float var8, float var9, long var10, long var12);
    }
}

