/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxJoint;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxRevoluteJointFlagEnum;
import physx.extensions.PxRevoluteJointFlags;

public class PxRevoluteJoint
extends PxJoint {
    public static final int SIZEOF = PxRevoluteJoint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRevoluteJoint() {
    }

    private static native int __sizeOf();

    public static PxRevoluteJoint wrapPointer(long address) {
        return address != 0L ? new PxRevoluteJoint(address) : null;
    }

    public static PxRevoluteJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRevoluteJoint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRevoluteJoint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getAngle() {
        this.checkNotNull();
        return Raw.getAngle(this.address);
    }

    public float getVelocity() {
        this.checkNotNull();
        return Raw.getVelocity(this.address);
    }

    public void setLimit(PxJointAngularLimitPair limits) {
        this.checkNotNull();
        Raw.setLimit(this.address, limits.getAddress());
    }

    public void setDriveVelocity(float velocity) {
        this.checkNotNull();
        Raw.setDriveVelocity(this.address, velocity);
    }

    public void setDriveVelocity(float velocity, boolean autowake) {
        this.checkNotNull();
        Raw.setDriveVelocity(this.address, velocity, autowake);
    }

    public float getDriveVelocity() {
        this.checkNotNull();
        return Raw.getDriveVelocity(this.address);
    }

    public void setDriveForceLimit(float limit) {
        this.checkNotNull();
        Raw.setDriveForceLimit(this.address, limit);
    }

    public float getDriveForceLimit() {
        this.checkNotNull();
        return Raw.getDriveForceLimit(this.address);
    }

    public void setDriveGearRatio(float ratio) {
        this.checkNotNull();
        Raw.setDriveGearRatio(this.address, ratio);
    }

    public float getDriveGearRatio() {
        this.checkNotNull();
        return Raw.getDriveGearRatio(this.address);
    }

    public void setRevoluteJointFlags(PxRevoluteJointFlags flags) {
        this.checkNotNull();
        Raw.setRevoluteJointFlags(this.address, flags.getAddress());
    }

    public void setRevoluteJointFlag(PxRevoluteJointFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setRevoluteJointFlag(this.address, flag.value, value);
    }

    public PxRevoluteJointFlags getRevoluteJointFlags() {
        this.checkNotNull();
        return PxRevoluteJointFlags.wrapPointer(Raw.getRevoluteJointFlags(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native float getAngle(long var0);

        public static native float getVelocity(long var0);

        public static native void setLimit(long var0, long var2);

        public static native void setDriveVelocity(long var0, float var2);

        public static native void setDriveVelocity(long var0, float var2, boolean var3);

        public static native float getDriveVelocity(long var0);

        public static native void setDriveForceLimit(long var0, float var2);

        public static native float getDriveForceLimit(long var0);

        public static native void setDriveGearRatio(long var0, float var2);

        public static native float getDriveGearRatio(long var0);

        public static native void setRevoluteJointFlags(long var0, long var2);

        public static native void setRevoluteJointFlag(long var0, int var2, boolean var3);

        public static native long getRevoluteJointFlags(long var0);
    }
}

