/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxOutputStream;

public class PxDefaultMemoryOutputStream
extends PxOutputStream {
    public static final int SIZEOF = PxDefaultMemoryOutputStream.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxDefaultMemoryOutputStream wrapPointer(long address) {
        return address != 0L ? new PxDefaultMemoryOutputStream(address) : null;
    }

    public static PxDefaultMemoryOutputStream arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxDefaultMemoryOutputStream.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxDefaultMemoryOutputStream(long address) {
        super(address);
    }

    public PxDefaultMemoryOutputStream() {
        this.address = Raw.PxDefaultMemoryOutputStream();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void write(NativeObject src, int count) {
        this.checkNotNull();
        Raw.write(this.address, src.getAddress(), count);
    }

    public int getSize() {
        this.checkNotNull();
        return Raw.getSize(this.address);
    }

    public NativeObject getData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getData(this.address));
    }

    public static class Raw {
        public static native long PxDefaultMemoryOutputStream();

        public static native void destroy(long var0);

        public static native void write(long var0, long var2, int var4);

        public static native int getSize(long var0);

        public static native long getData(long var0);
    }
}

