/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxInputData;
import physx.support.PxU8Ptr;

public class PxDefaultMemoryInputData
extends PxInputData {
    public static final int SIZEOF = PxDefaultMemoryInputData.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxDefaultMemoryInputData() {
    }

    private static native int __sizeOf();

    public static PxDefaultMemoryInputData wrapPointer(long address) {
        return address != 0L ? new PxDefaultMemoryInputData(address) : null;
    }

    public static PxDefaultMemoryInputData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxDefaultMemoryInputData.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxDefaultMemoryInputData(long address) {
        super(address);
    }

    public PxDefaultMemoryInputData(PxU8Ptr data, int length) {
        this.address = Raw.PxDefaultMemoryInputData(data.getAddress(), length);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int read(NativeObject dest, int count) {
        this.checkNotNull();
        return Raw.read(this.address, dest.getAddress(), count);
    }

    public int getLength() {
        this.checkNotNull();
        return Raw.getLength(this.address);
    }

    public void seek(int pos) {
        this.checkNotNull();
        Raw.seek(this.address, pos);
    }

    public int tell() {
        this.checkNotNull();
        return Raw.tell(this.address);
    }

    public static class Raw {
        public static native long PxDefaultMemoryInputData(long var0, int var2);

        public static native void destroy(long var0);

        public static native int read(long var0, long var2, int var4);

        public static native int getLength(long var0);

        public static native void seek(long var0, int var2);

        public static native int tell(long var0);
    }
}

