/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxCollection;
import physx.physics.PxScene;

public class PxCollectionExt
extends NativeObject {
    public static final int SIZEOF = PxCollectionExt.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxCollectionExt() {
    }

    private static native int __sizeOf();

    public static PxCollectionExt wrapPointer(long address) {
        return address != 0L ? new PxCollectionExt(address) : null;
    }

    public static PxCollectionExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCollectionExt.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCollectionExt(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static void releaseObjects(PxCollection collection) {
        Raw.releaseObjects(collection.getAddress());
    }

    public static void releaseObjects(PxCollection collection, boolean releaseExclusiveShapes) {
        Raw.releaseObjects(collection.getAddress(), releaseExclusiveShapes);
    }

    public static void remove(PxCollection collection, short concreteType) {
        Raw.remove(collection.getAddress(), concreteType);
    }

    public static void remove(PxCollection collection, short concreteType, PxCollection to) {
        Raw.remove(collection.getAddress(), concreteType, to.getAddress());
    }

    public static PxCollection createCollection(PxScene scene) {
        return PxCollection.wrapPointer(Raw.createCollection(scene.getAddress()));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void releaseObjects(long var0);

        public static native void releaseObjects(long var0, boolean var2);

        public static native void remove(long var0, short var2);

        public static native void remove(long var0, short var2, long var3);

        public static native long createCollection(long var0);
    }
}

