/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.extensions.Support;
import physx.geometry.PxGeometry;

public class ConvexGeomSupport
extends Support {
    public static final int SIZEOF = ConvexGeomSupport.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static ConvexGeomSupport wrapPointer(long address) {
        return address != 0L ? new ConvexGeomSupport(address) : null;
    }

    public static ConvexGeomSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return ConvexGeomSupport.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected ConvexGeomSupport(long address) {
        super(address);
    }

    public static ConvexGeomSupport createAt(long address) {
        Raw.ConvexGeomSupport_placed(address);
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexGeomSupport createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexGeomSupport_placed(address);
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static ConvexGeomSupport createAt(long address, PxGeometry geom) {
        Raw.ConvexGeomSupport_placed(address, geom.getAddress());
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexGeomSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxGeometry geom) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexGeomSupport_placed(address, geom.getAddress());
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static ConvexGeomSupport createAt(long address, PxGeometry geom, float margin) {
        Raw.ConvexGeomSupport_placed(address, geom.getAddress(), margin);
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexGeomSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxGeometry geom, float margin) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexGeomSupport_placed(address, geom.getAddress(), margin);
        ConvexGeomSupport createdObj = ConvexGeomSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public ConvexGeomSupport() {
        this.address = Raw.ConvexGeomSupport();
    }

    public ConvexGeomSupport(PxGeometry geom) {
        this.address = Raw.ConvexGeomSupport(geom.getAddress());
    }

    public ConvexGeomSupport(PxGeometry geom, float margin) {
        this.address = Raw.ConvexGeomSupport(geom.getAddress(), margin);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static class Raw {
        public static native void ConvexGeomSupport_placed(long var0);

        public static native void ConvexGeomSupport_placed(long var0, long var2);

        public static native void ConvexGeomSupport_placed(long var0, long var2, float var4);

        public static native long ConvexGeomSupport();

        public static native long ConvexGeomSupport(long var0);

        public static native long ConvexGeomSupport(long var0, float var2);

        public static native void destroy(long var0);
    }
}

