/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.extensions.Support;

public class CapsuleSupport
extends Support {
    public static final int SIZEOF = CapsuleSupport.__sizeOf();
    public static final int ALIGNOF = 8;

    protected CapsuleSupport() {
    }

    private static native int __sizeOf();

    public static CapsuleSupport wrapPointer(long address) {
        return address != 0L ? new CapsuleSupport(address) : null;
    }

    public static CapsuleSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return CapsuleSupport.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected CapsuleSupport(long address) {
        super(address);
    }

    public static CapsuleSupport createAt(long address, float radius, float halfHeight) {
        Raw.CapsuleSupport_placed(address, radius, halfHeight);
        CapsuleSupport createdObj = CapsuleSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> CapsuleSupport createAt(T allocator, NativeObject.Allocator<T> allocate, float radius, float halfHeight) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.CapsuleSupport_placed(address, radius, halfHeight);
        CapsuleSupport createdObj = CapsuleSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public CapsuleSupport(float radius, float halfHeight) {
        this.address = Raw.CapsuleSupport(radius, halfHeight);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getRadius() {
        this.checkNotNull();
        return Raw.getRadius(this.address);
    }

    public void setRadius(float value) {
        this.checkNotNull();
        Raw.setRadius(this.address, value);
    }

    public float getHalfHeight() {
        this.checkNotNull();
        return Raw.getHalfHeight(this.address);
    }

    public void setHalfHeight(float value) {
        this.checkNotNull();
        Raw.setHalfHeight(this.address, value);
    }

    public static class Raw {
        public static native void CapsuleSupport_placed(long var0, float var2, float var3);

        public static native long CapsuleSupport(float var0, float var1);

        public static native void destroy(long var0);

        public static native float getRadius(long var0);

        public static native void setRadius(long var0, float var2);

        public static native float getHalfHeight(long var0);

        public static native void setHalfHeight(long var0, float var2);
    }
}

