/*
 * Decompiled with CFR 0.152.
 */
package physx.cooking;

import physx.NativeObject;
import physx.common.PxTolerancesScale;
import physx.cooking.PxConvexMeshCookingTypeEnum;
import physx.cooking.PxMeshPreprocessingFlags;
import physx.cooking.PxMidphaseDesc;

public class PxCookingParams
extends NativeObject {
    public static final int SIZEOF = PxCookingParams.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxCookingParams() {
    }

    private static native int __sizeOf();

    public static PxCookingParams wrapPointer(long address) {
        return address != 0L ? new PxCookingParams(address) : null;
    }

    public static PxCookingParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCookingParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCookingParams(long address) {
        super(address);
    }

    public PxCookingParams(PxTolerancesScale sc) {
        this.address = Raw.PxCookingParams(sc.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getAreaTestEpsilon() {
        this.checkNotNull();
        return Raw.getAreaTestEpsilon(this.address);
    }

    public void setAreaTestEpsilon(float value) {
        this.checkNotNull();
        Raw.setAreaTestEpsilon(this.address, value);
    }

    public float getPlaneTolerance() {
        this.checkNotNull();
        return Raw.getPlaneTolerance(this.address);
    }

    public void setPlaneTolerance(float value) {
        this.checkNotNull();
        Raw.setPlaneTolerance(this.address, value);
    }

    public PxConvexMeshCookingTypeEnum getConvexMeshCookingType() {
        this.checkNotNull();
        return PxConvexMeshCookingTypeEnum.forValue(Raw.getConvexMeshCookingType(this.address));
    }

    public void setConvexMeshCookingType(PxConvexMeshCookingTypeEnum value) {
        this.checkNotNull();
        Raw.setConvexMeshCookingType(this.address, value.value);
    }

    public boolean getSuppressTriangleMeshRemapTable() {
        this.checkNotNull();
        return Raw.getSuppressTriangleMeshRemapTable(this.address);
    }

    public void setSuppressTriangleMeshRemapTable(boolean value) {
        this.checkNotNull();
        Raw.setSuppressTriangleMeshRemapTable(this.address, value);
    }

    public boolean getBuildTriangleAdjacencies() {
        this.checkNotNull();
        return Raw.getBuildTriangleAdjacencies(this.address);
    }

    public void setBuildTriangleAdjacencies(boolean value) {
        this.checkNotNull();
        Raw.setBuildTriangleAdjacencies(this.address, value);
    }

    public boolean getBuildGPUData() {
        this.checkNotNull();
        return Raw.getBuildGPUData(this.address);
    }

    public void setBuildGPUData(boolean value) {
        this.checkNotNull();
        Raw.setBuildGPUData(this.address, value);
    }

    public PxTolerancesScale getScale() {
        this.checkNotNull();
        return PxTolerancesScale.wrapPointer(Raw.getScale(this.address));
    }

    public void setScale(PxTolerancesScale value) {
        this.checkNotNull();
        Raw.setScale(this.address, value.getAddress());
    }

    public PxMeshPreprocessingFlags getMeshPreprocessParams() {
        this.checkNotNull();
        return PxMeshPreprocessingFlags.wrapPointer(Raw.getMeshPreprocessParams(this.address));
    }

    public void setMeshPreprocessParams(PxMeshPreprocessingFlags value) {
        this.checkNotNull();
        Raw.setMeshPreprocessParams(this.address, value.getAddress());
    }

    public float getMeshWeldTolerance() {
        this.checkNotNull();
        return Raw.getMeshWeldTolerance(this.address);
    }

    public void setMeshWeldTolerance(float value) {
        this.checkNotNull();
        Raw.setMeshWeldTolerance(this.address, value);
    }

    public PxMidphaseDesc getMidphaseDesc() {
        this.checkNotNull();
        return PxMidphaseDesc.wrapPointer(Raw.getMidphaseDesc(this.address));
    }

    public void setMidphaseDesc(PxMidphaseDesc value) {
        this.checkNotNull();
        Raw.setMidphaseDesc(this.address, value.getAddress());
    }

    public int getGaussMapLimit() {
        this.checkNotNull();
        return Raw.getGaussMapLimit(this.address);
    }

    public void setGaussMapLimit(int value) {
        this.checkNotNull();
        Raw.setGaussMapLimit(this.address, value);
    }

    public static class Raw {
        public static native long PxCookingParams(long var0);

        public static native void destroy(long var0);

        public static native float getAreaTestEpsilon(long var0);

        public static native void setAreaTestEpsilon(long var0, float var2);

        public static native float getPlaneTolerance(long var0);

        public static native void setPlaneTolerance(long var0, float var2);

        public static native int getConvexMeshCookingType(long var0);

        public static native void setConvexMeshCookingType(long var0, int var2);

        public static native boolean getSuppressTriangleMeshRemapTable(long var0);

        public static native void setSuppressTriangleMeshRemapTable(long var0, boolean var2);

        public static native boolean getBuildTriangleAdjacencies(long var0);

        public static native void setBuildTriangleAdjacencies(long var0, boolean var2);

        public static native boolean getBuildGPUData(long var0);

        public static native void setBuildGPUData(long var0, boolean var2);

        public static native long getScale(long var0);

        public static native void setScale(long var0, long var2);

        public static native long getMeshPreprocessParams(long var0);

        public static native void setMeshPreprocessParams(long var0, long var2);

        public static native float getMeshWeldTolerance(long var0);

        public static native void setMeshWeldTolerance(long var0, float var2);

        public static native long getMidphaseDesc(long var0);

        public static native void setMidphaseDesc(long var0, long var2);

        public static native int getGaussMapLimit(long var0);

        public static native void setGaussMapLimit(long var0, int var2);
    }
}

