/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxTolerancesScale
extends NativeObject {
    public static final int SIZEOF = PxTolerancesScale.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxTolerancesScale wrapPointer(long address) {
        return address != 0L ? new PxTolerancesScale(address) : null;
    }

    public static PxTolerancesScale arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTolerancesScale.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTolerancesScale(long address) {
        super(address);
    }

    public PxTolerancesScale() {
        this.address = Raw.PxTolerancesScale();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getLength() {
        this.checkNotNull();
        return Raw.getLength(this.address);
    }

    public void setLength(float value) {
        this.checkNotNull();
        Raw.setLength(this.address, value);
    }

    public float getSpeed() {
        this.checkNotNull();
        return Raw.getSpeed(this.address);
    }

    public void setSpeed(float value) {
        this.checkNotNull();
        Raw.setSpeed(this.address, value);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long PxTolerancesScale();

        public static native void destroy(long var0);

        public static native float getLength(long var0);

        public static native void setLength(long var0, float var2);

        public static native float getSpeed(long var0);

        public static native void setSpeed(long var0, float var2);

        public static native boolean isValid(long var0);
    }
}

