/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxDebugLine;
import physx.common.PxDebugPoint;
import physx.common.PxDebugTriangle;
import physx.common.PxVec3;

public class PxRenderBuffer
extends NativeObject {
    public static final int SIZEOF = PxRenderBuffer.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRenderBuffer() {
    }

    private static native int __sizeOf();

    public static PxRenderBuffer wrapPointer(long address) {
        return address != 0L ? new PxRenderBuffer(address) : null;
    }

    public static PxRenderBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRenderBuffer.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRenderBuffer(long address) {
        super(address);
    }

    public int getNbPoints() {
        this.checkNotNull();
        return Raw.getNbPoints(this.address);
    }

    public PxDebugPoint getPoints() {
        this.checkNotNull();
        return PxDebugPoint.wrapPointer(Raw.getPoints(this.address));
    }

    public void addPoint(PxDebugPoint point) {
        this.checkNotNull();
        Raw.addPoint(this.address, point.getAddress());
    }

    public int getNbLines() {
        this.checkNotNull();
        return Raw.getNbLines(this.address);
    }

    public PxDebugLine getLines() {
        this.checkNotNull();
        return PxDebugLine.wrapPointer(Raw.getLines(this.address));
    }

    public void addLine(PxDebugLine line) {
        this.checkNotNull();
        Raw.addLine(this.address, line.getAddress());
    }

    public PxDebugLine reserveLines(int nbLines) {
        this.checkNotNull();
        return PxDebugLine.wrapPointer(Raw.reserveLines(this.address, nbLines));
    }

    public PxDebugPoint reservePoints(int nbLines) {
        this.checkNotNull();
        return PxDebugPoint.wrapPointer(Raw.reservePoints(this.address, nbLines));
    }

    public int getNbTriangles() {
        this.checkNotNull();
        return Raw.getNbTriangles(this.address);
    }

    public PxDebugTriangle getTriangles() {
        this.checkNotNull();
        return PxDebugTriangle.wrapPointer(Raw.getTriangles(this.address));
    }

    public void addTriangle(PxDebugTriangle triangle) {
        this.checkNotNull();
        Raw.addTriangle(this.address, triangle.getAddress());
    }

    public void append(PxRenderBuffer other) {
        this.checkNotNull();
        Raw.append(this.address, other.getAddress());
    }

    public void clear() {
        this.checkNotNull();
        Raw.clear(this.address);
    }

    public void shift(PxVec3 delta) {
        this.checkNotNull();
        Raw.shift(this.address, delta.getAddress());
    }

    public boolean empty() {
        this.checkNotNull();
        return Raw.empty(this.address);
    }

    public static class Raw {
        public static native int getNbPoints(long var0);

        public static native long getPoints(long var0);

        public static native void addPoint(long var0, long var2);

        public static native int getNbLines(long var0);

        public static native long getLines(long var0);

        public static native void addLine(long var0, long var2);

        public static native long reserveLines(long var0, int var2);

        public static native long reservePoints(long var0, int var2);

        public static native int getNbTriangles(long var0);

        public static native long getTriangles(long var0);

        public static native void addTriangle(long var0, long var2);

        public static native void append(long var0, long var2);

        public static native void clear(long var0);

        public static native void shift(long var0, long var2);

        public static native boolean empty(long var0);
    }
}

