/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxIDENTITYEnum;
import physx.common.PxMat33;
import physx.common.PxVec3;

public class PxQuat
extends NativeObject {
    public static final int SIZEOF = PxQuat.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxQuat wrapPointer(long address) {
        return address != 0L ? new PxQuat(address) : null;
    }

    public static PxQuat arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxQuat.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxQuat(long address) {
        super(address);
    }

    public static PxQuat createAt(long address) {
        Raw.PxQuat_placed(address);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxQuat createAt(long address, PxIDENTITYEnum r) {
        Raw.PxQuat_placed(address, r.value);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate, PxIDENTITYEnum r) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address, r.value);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxQuat createAt(long address, float nx, float ny, float nz, float nw) {
        Raw.PxQuat_placed(address, nx, ny, nz, nw);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate, float nx, float ny, float nz, float nw) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address, nx, ny, nz, nw);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxQuat createAt(long address, float angleRadians, PxVec3 unitAxis) {
        Raw.PxQuat_placed(address, angleRadians, unitAxis.getAddress());
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate, float angleRadians, PxVec3 unitAxis) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address, angleRadians, unitAxis.getAddress());
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxQuat createAt(long address, float r) {
        PlatformChecks.requirePlatform(15, "physx.common.PxQuat");
        Raw.PxQuat_placed(address, r);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate, float r) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address, r);
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxQuat createAt(long address, PxMat33 m) {
        PlatformChecks.requirePlatform(15, "physx.common.PxQuat");
        Raw.PxQuat_placed(address, m.getAddress());
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxQuat createAt(T allocator, NativeObject.Allocator<T> allocate, PxMat33 m) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxQuat_placed(address, m.getAddress());
        PxQuat createdObj = PxQuat.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxQuat() {
        this.address = Raw.PxQuat();
    }

    public PxQuat(PxIDENTITYEnum r) {
        this.address = Raw.PxQuat(r.value);
    }

    public PxQuat(float nx, float ny, float nz, float nw) {
        this.address = Raw.PxQuat(nx, ny, nz, nw);
    }

    public PxQuat(float angleRadians, PxVec3 unitAxis) {
        this.address = Raw.PxQuat(angleRadians, unitAxis.getAddress());
    }

    public PxQuat(float r) {
        PlatformChecks.requirePlatform(15, "physx.common.PxQuat");
        this.address = Raw.PxQuat(r);
    }

    public PxQuat(PxMat33 m) {
        PlatformChecks.requirePlatform(15, "physx.common.PxQuat");
        this.address = Raw.PxQuat(m.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getX() {
        this.checkNotNull();
        return Raw.getX(this.address);
    }

    public void setX(float value) {
        this.checkNotNull();
        Raw.setX(this.address, value);
    }

    public float getY() {
        this.checkNotNull();
        return Raw.getY(this.address);
    }

    public void setY(float value) {
        this.checkNotNull();
        Raw.setY(this.address, value);
    }

    public float getZ() {
        this.checkNotNull();
        return Raw.getZ(this.address);
    }

    public void setZ(float value) {
        this.checkNotNull();
        Raw.setZ(this.address, value);
    }

    public float getW() {
        this.checkNotNull();
        return Raw.getW(this.address);
    }

    public void setW(float value) {
        this.checkNotNull();
        Raw.setW(this.address, value);
    }

    public boolean isIdentity() {
        this.checkNotNull();
        return Raw.isIdentity(this.address);
    }

    public boolean isFinite() {
        this.checkNotNull();
        return Raw.isFinite(this.address);
    }

    public boolean isUnit() {
        this.checkNotNull();
        return Raw.isUnit(this.address);
    }

    public boolean isSane() {
        this.checkNotNull();
        return Raw.isSane(this.address);
    }

    public float getAngle() {
        this.checkNotNull();
        return Raw.getAngle(this.address);
    }

    public float getAngle(PxQuat q) {
        this.checkNotNull();
        return Raw.getAngle(this.address, q.getAddress());
    }

    public float magnitudeSquared() {
        this.checkNotNull();
        return Raw.magnitudeSquared(this.address);
    }

    public float dot(PxQuat q) {
        this.checkNotNull();
        return Raw.dot(this.address, q.getAddress());
    }

    public PxQuat getNormalized() {
        this.checkNotNull();
        return PxQuat.wrapPointer(Raw.getNormalized(this.address));
    }

    public float magnitude() {
        this.checkNotNull();
        return Raw.magnitude(this.address);
    }

    public float normalize() {
        this.checkNotNull();
        return Raw.normalize(this.address);
    }

    public PxQuat getConjugate() {
        this.checkNotNull();
        return PxQuat.wrapPointer(Raw.getConjugate(this.address));
    }

    public PxVec3 getImaginaryPart() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getImaginaryPart(this.address));
    }

    public PxVec3 getBasisVector0() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getBasisVector0(this.address));
    }

    public PxVec3 getBasisVector1() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getBasisVector1(this.address));
    }

    public PxVec3 getBasisVector2() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getBasisVector2(this.address));
    }

    public PxVec3 rotate(PxVec3 v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.rotate(this.address, v.getAddress()));
    }

    public PxVec3 rotateInv(PxVec3 v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.rotateInv(this.address, v.getAddress()));
    }

    public static class Raw {
        public static native void PxQuat_placed(long var0);

        public static native void PxQuat_placed(long var0, int var2);

        public static native void PxQuat_placed(long var0, float var2, float var3, float var4, float var5);

        public static native void PxQuat_placed(long var0, float var2, long var3);

        public static native void PxQuat_placed(long var0, float var2);

        public static native void PxQuat_placed(long var0, long var2);

        public static native long PxQuat();

        public static native long PxQuat(int var0);

        public static native long PxQuat(float var0, float var1, float var2, float var3);

        public static native long PxQuat(float var0, long var1);

        public static native long PxQuat(float var0);

        public static native long PxQuat(long var0);

        public static native void destroy(long var0);

        public static native float getX(long var0);

        public static native void setX(long var0, float var2);

        public static native float getY(long var0);

        public static native void setY(long var0, float var2);

        public static native float getZ(long var0);

        public static native void setZ(long var0, float var2);

        public static native float getW(long var0);

        public static native void setW(long var0, float var2);

        public static native boolean isIdentity(long var0);

        public static native boolean isFinite(long var0);

        public static native boolean isUnit(long var0);

        public static native boolean isSane(long var0);

        public static native float getAngle(long var0);

        public static native float getAngle(long var0, long var2);

        public static native float magnitudeSquared(long var0);

        public static native float dot(long var0, long var2);

        public static native long getNormalized(long var0);

        public static native float magnitude(long var0);

        public static native float normalize(long var0);

        public static native long getConjugate(long var0);

        public static native long getImaginaryPart(long var0);

        public static native long getBasisVector0(long var0);

        public static native long getBasisVector1(long var0);

        public static native long getBasisVector2(long var0);

        public static native long rotate(long var0, long var2);

        public static native long rotateInv(long var0, long var2);
    }
}

