/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxDebugPoint
extends NativeObject {
    public static final int SIZEOF = PxDebugPoint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxDebugPoint() {
    }

    private static native int __sizeOf();

    public static PxDebugPoint wrapPointer(long address) {
        return address != 0L ? new PxDebugPoint(address) : null;
    }

    public static PxDebugPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxDebugPoint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxDebugPoint(long address) {
        super(address);
    }

    public PxVec3 getPos() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getPos(this.address));
    }

    public void setPos(PxVec3 value) {
        this.checkNotNull();
        Raw.setPos(this.address, value.getAddress());
    }

    public int getColor() {
        this.checkNotNull();
        return Raw.getColor(this.address);
    }

    public void setColor(int value) {
        this.checkNotNull();
        Raw.setColor(this.address, value);
    }

    public static class Raw {
        public static native long getPos(long var0);

        public static native void setPos(long var0, long var2);

        public static native int getColor(long var0);

        public static native void setColor(long var0, int var2);
    }
}

