/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxBase;

public class PxCollection
extends NativeObject {
    public static final int SIZEOF = PxCollection.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxCollection() {
    }

    private static native int __sizeOf();

    public static PxCollection wrapPointer(long address) {
        return address != 0L ? new PxCollection(address) : null;
    }

    public static PxCollection arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCollection.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCollection(long address) {
        super(address);
    }

    public void add(PxBase obj) {
        this.checkNotNull();
        Raw.add(this.address, obj.getAddress());
    }

    public void add(PxBase obj, long id) {
        this.checkNotNull();
        Raw.add(this.address, obj.getAddress(), id);
    }

    public void remove(PxBase obj) {
        this.checkNotNull();
        Raw.remove(this.address, obj.getAddress());
    }

    public boolean contains(PxBase obj) {
        this.checkNotNull();
        return Raw.contains(this.address, obj.getAddress());
    }

    public void addId(PxBase obj, long id) {
        this.checkNotNull();
        Raw.addId(this.address, obj.getAddress(), id);
    }

    public void removeId(long id) {
        this.checkNotNull();
        Raw.removeId(this.address, id);
    }

    public int getNbObjects() {
        this.checkNotNull();
        return Raw.getNbObjects(this.address);
    }

    public PxBase getObject(int index) {
        this.checkNotNull();
        return PxBase.wrapPointer(Raw.getObject(this.address, index));
    }

    public PxBase find(long id) {
        this.checkNotNull();
        return PxBase.wrapPointer(Raw.find(this.address, id));
    }

    public int getNbIds() {
        this.checkNotNull();
        return Raw.getNbIds(this.address);
    }

    public long getId(PxBase obj) {
        this.checkNotNull();
        return Raw.getId(this.address, obj.getAddress());
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public static class Raw {
        public static native void add(long var0, long var2);

        public static native void add(long var0, long var2, long var4);

        public static native void remove(long var0, long var2);

        public static native boolean contains(long var0, long var2);

        public static native void addId(long var0, long var2, long var4);

        public static native void removeId(long var0, long var2);

        public static native int getNbObjects(long var0);

        public static native long getObject(long var0, int var2);

        public static native long find(long var0, long var2);

        public static native int getNbIds(long var0);

        public static native long getId(long var0, long var2);

        public static native void release(long var0);
    }
}

