/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxBounds3
extends NativeObject {
    public static final int SIZEOF = PxBounds3.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxBounds3 wrapPointer(long address) {
        return address != 0L ? new PxBounds3(address) : null;
    }

    public static PxBounds3 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBounds3.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBounds3(long address) {
        super(address);
    }

    public static PxBounds3 createAt(long address) {
        Raw.PxBounds3_placed(address);
        PxBounds3 createdObj = PxBounds3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxBounds3 createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxBounds3_placed(address);
        PxBounds3 createdObj = PxBounds3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxBounds3 createAt(long address, PxVec3 minimum, PxVec3 maximum) {
        Raw.PxBounds3_placed(address, minimum.getAddress(), maximum.getAddress());
        PxBounds3 createdObj = PxBounds3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxBounds3 createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 minimum, PxVec3 maximum) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxBounds3_placed(address, minimum.getAddress(), maximum.getAddress());
        PxBounds3 createdObj = PxBounds3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxBounds3() {
        this.address = Raw.PxBounds3();
    }

    public PxBounds3(PxVec3 minimum, PxVec3 maximum) {
        this.address = Raw.PxBounds3(minimum.getAddress(), maximum.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getMinimum() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getMinimum(this.address));
    }

    public void setMinimum(PxVec3 value) {
        this.checkNotNull();
        Raw.setMinimum(this.address, value.getAddress());
    }

    public PxVec3 getMaximum() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getMaximum(this.address));
    }

    public void setMaximum(PxVec3 value) {
        this.checkNotNull();
        Raw.setMaximum(this.address, value.getAddress());
    }

    public void setEmpty() {
        this.checkNotNull();
        Raw.setEmpty(this.address);
    }

    public void setMaximal() {
        this.checkNotNull();
        Raw.setMaximal(this.address);
    }

    public void include(PxVec3 v) {
        this.checkNotNull();
        Raw.include(this.address, v.getAddress());
    }

    public boolean isEmpty() {
        this.checkNotNull();
        return Raw.isEmpty(this.address);
    }

    public boolean intersects(PxBounds3 b) {
        this.checkNotNull();
        return Raw.intersects(this.address, b.getAddress());
    }

    public boolean intersects1D(PxBounds3 b, int axis) {
        this.checkNotNull();
        return Raw.intersects1D(this.address, b.getAddress(), axis);
    }

    public boolean contains(PxVec3 v) {
        this.checkNotNull();
        return Raw.contains(this.address, v.getAddress());
    }

    public boolean isInside(PxBounds3 box) {
        this.checkNotNull();
        return Raw.isInside(this.address, box.getAddress());
    }

    public PxVec3 getCenter() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getCenter(this.address));
    }

    public PxVec3 getDimensions() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getDimensions(this.address));
    }

    public PxVec3 getExtents() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getExtents(this.address));
    }

    public void scaleSafe(float scale) {
        this.checkNotNull();
        Raw.scaleSafe(this.address, scale);
    }

    public void scaleFast(float scale) {
        this.checkNotNull();
        Raw.scaleFast(this.address, scale);
    }

    public void fattenSafe(float distance) {
        this.checkNotNull();
        Raw.fattenSafe(this.address, distance);
    }

    public void fattenFast(float distance) {
        this.checkNotNull();
        Raw.fattenFast(this.address, distance);
    }

    public boolean isFinite() {
        this.checkNotNull();
        return Raw.isFinite(this.address);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxBounds3_placed(long var0);

        public static native void PxBounds3_placed(long var0, long var2, long var4);

        public static native long PxBounds3();

        public static native long PxBounds3(long var0, long var2);

        public static native void destroy(long var0);

        public static native long getMinimum(long var0);

        public static native void setMinimum(long var0, long var2);

        public static native long getMaximum(long var0);

        public static native void setMaximum(long var0, long var2);

        public static native void setEmpty(long var0);

        public static native void setMaximal(long var0);

        public static native void include(long var0, long var2);

        public static native boolean isEmpty(long var0);

        public static native boolean intersects(long var0, long var2);

        public static native boolean intersects1D(long var0, long var2, int var4);

        public static native boolean contains(long var0, long var2);

        public static native boolean isInside(long var0, long var2);

        public static native long getCenter(long var0);

        public static native long getDimensions(long var0);

        public static native long getExtents(long var0);

        public static native void scaleSafe(long var0, float var2);

        public static native void scaleFast(long var0, float var2);

        public static native void fattenSafe(long var0, float var2);

        public static native void fattenFast(long var0, float var2);

        public static native boolean isFinite(long var0);

        public static native boolean isValid(long var0);
    }
}

