/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.character.PxControllerManager;
import physx.character.PxObstacle;

public class PxObstacleContext
extends NativeObject {
    public static final int SIZEOF = PxObstacleContext.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxObstacleContext() {
    }

    private static native int __sizeOf();

    public static PxObstacleContext wrapPointer(long address) {
        return address != 0L ? new PxObstacleContext(address) : null;
    }

    public static PxObstacleContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxObstacleContext.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxObstacleContext(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public PxControllerManager getControllerManager() {
        this.checkNotNull();
        return PxControllerManager.wrapPointer(Raw.getControllerManager(this.address));
    }

    public int addObstacle(PxObstacle obstacle) {
        this.checkNotNull();
        return Raw.addObstacle(this.address, obstacle.getAddress());
    }

    public boolean removeObstacle(int handle) {
        this.checkNotNull();
        return Raw.removeObstacle(this.address, handle);
    }

    public boolean updateObstacle(int handle, PxObstacle obstacle) {
        this.checkNotNull();
        return Raw.updateObstacle(this.address, handle, obstacle.getAddress());
    }

    public int getNbObstacles() {
        this.checkNotNull();
        return Raw.getNbObstacles(this.address);
    }

    public PxObstacle getObstacle(int i) {
        this.checkNotNull();
        return PxObstacle.wrapPointer(Raw.getObstacle(this.address, i));
    }

    public PxObstacle getObstacleByHandle(int handle) {
        this.checkNotNull();
        return PxObstacle.wrapPointer(Raw.getObstacleByHandle(this.address, handle));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void release(long var0);

        public static native long getControllerManager(long var0);

        public static native int addObstacle(long var0, long var2);

        public static native boolean removeObstacle(long var0, int var2);

        public static native boolean updateObstacle(long var0, int var2, long var3);

        public static native int getNbObstacles(long var0);

        public static native long getObstacle(long var0, int var2);

        public static native long getObstacleByHandle(long var0, int var2);
    }
}

