/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.character.PxExtendedVec3;
import physx.common.PxQuat;
import physx.geometry.PxGeometryTypeEnum;

public class PxObstacle
extends NativeObject {
    public static final int SIZEOF = PxObstacle.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxObstacle() {
    }

    private static native int __sizeOf();

    public static PxObstacle wrapPointer(long address) {
        return address != 0L ? new PxObstacle(address) : null;
    }

    public static PxObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxObstacle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxObstacle(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public NativeObject getMUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getMUserData(this.address));
    }

    public void setMUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setMUserData(this.address, value.getAddress());
    }

    public PxExtendedVec3 getMPos() {
        this.checkNotNull();
        return PxExtendedVec3.wrapPointer(Raw.getMPos(this.address));
    }

    public void setMPos(PxExtendedVec3 value) {
        this.checkNotNull();
        Raw.setMPos(this.address, value.getAddress());
    }

    public PxQuat getMRot() {
        this.checkNotNull();
        return PxQuat.wrapPointer(Raw.getMRot(this.address));
    }

    public void setMRot(PxQuat value) {
        this.checkNotNull();
        Raw.setMRot(this.address, value.getAddress());
    }

    public PxGeometryTypeEnum getType() {
        this.checkNotNull();
        return PxGeometryTypeEnum.forValue(Raw.getType(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getMUserData(long var0);

        public static native void setMUserData(long var0, long var2);

        public static native long getMPos(long var0);

        public static native void setMPos(long var0, long var2);

        public static native long getMRot(long var0);

        public static native void setMRot(long var0, long var2);

        public static native int getType(long var0);
    }
}

