/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.character.PxControllerCollisionFlags;
import physx.character.PxControllerFilters;
import physx.character.PxControllerNonWalkableModeEnum;
import physx.character.PxControllerShapeTypeEnum;
import physx.character.PxControllerState;
import physx.character.PxControllerStats;
import physx.character.PxExtendedVec3;
import physx.character.PxObstacleContext;
import physx.common.PxVec3;
import physx.physics.PxRigidDynamic;
import physx.physics.PxScene;

public class PxController
extends NativeObject {
    public static final int SIZEOF = PxController.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxController() {
    }

    private static native int __sizeOf();

    public static PxController wrapPointer(long address) {
        return address != 0L ? new PxController(address) : null;
    }

    public static PxController arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxController.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxController(long address) {
        super(address);
    }

    public PxControllerShapeTypeEnum getType() {
        this.checkNotNull();
        return PxControllerShapeTypeEnum.forValue(Raw.getType(this.address));
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public PxControllerCollisionFlags move(PxVec3 disp, float minDist, float elapsedTime, PxControllerFilters filters) {
        this.checkNotNull();
        return PxControllerCollisionFlags.wrapPointer(Raw.move(this.address, disp.getAddress(), minDist, elapsedTime, filters.getAddress()));
    }

    public PxControllerCollisionFlags move(PxVec3 disp, float minDist, float elapsedTime, PxControllerFilters filters, PxObstacleContext obstacles) {
        this.checkNotNull();
        return PxControllerCollisionFlags.wrapPointer(Raw.move(this.address, disp.getAddress(), minDist, elapsedTime, filters.getAddress(), obstacles.getAddress()));
    }

    public boolean setPosition(PxExtendedVec3 position) {
        this.checkNotNull();
        return Raw.setPosition(this.address, position.getAddress());
    }

    public PxExtendedVec3 getPosition() {
        this.checkNotNull();
        return PxExtendedVec3.wrapPointer(Raw.getPosition(this.address));
    }

    public boolean setFootPosition(PxExtendedVec3 position) {
        this.checkNotNull();
        return Raw.setFootPosition(this.address, position.getAddress());
    }

    public PxExtendedVec3 getFootPosition() {
        this.checkNotNull();
        return PxExtendedVec3.wrapPointer(Raw.getFootPosition(this.address));
    }

    public PxRigidDynamic getActor() {
        this.checkNotNull();
        return PxRigidDynamic.wrapPointer(Raw.getActor(this.address));
    }

    public void setStepOffset(float offset) {
        this.checkNotNull();
        Raw.setStepOffset(this.address, offset);
    }

    public float getStepOffset() {
        this.checkNotNull();
        return Raw.getStepOffset(this.address);
    }

    public void setNonWalkableMode(PxControllerNonWalkableModeEnum flag) {
        this.checkNotNull();
        Raw.setNonWalkableMode(this.address, flag.value);
    }

    public PxControllerNonWalkableModeEnum getNonWalkableMode() {
        this.checkNotNull();
        return PxControllerNonWalkableModeEnum.forValue(Raw.getNonWalkableMode(this.address));
    }

    public float getContactOffset() {
        this.checkNotNull();
        return Raw.getContactOffset(this.address);
    }

    public void setContactOffset(float offset) {
        this.checkNotNull();
        Raw.setContactOffset(this.address, offset);
    }

    public PxVec3 getUpDirection() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getUpDirection(this.address));
    }

    public void setUpDirection(PxVec3 up) {
        this.checkNotNull();
        Raw.setUpDirection(this.address, up.getAddress());
    }

    public float getSlopeLimit() {
        this.checkNotNull();
        return Raw.getSlopeLimit(this.address);
    }

    public void setSlopeLimit(float slopeLimit) {
        this.checkNotNull();
        Raw.setSlopeLimit(this.address, slopeLimit);
    }

    public void invalidateCache() {
        this.checkNotNull();
        Raw.invalidateCache(this.address);
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject userData) {
        this.checkNotNull();
        Raw.setUserData(this.address, userData.getAddress());
    }

    public void getState(PxControllerState state) {
        this.checkNotNull();
        Raw.getState(this.address, state.getAddress());
    }

    public void getStats(PxControllerStats stats) {
        this.checkNotNull();
        Raw.getStats(this.address, stats.getAddress());
    }

    public void resize(float height) {
        this.checkNotNull();
        Raw.resize(this.address, height);
    }

    public static class Raw {
        public static native int getType(long var0);

        public static native void release(long var0);

        public static native long move(long var0, long var2, float var4, float var5, long var6);

        public static native long move(long var0, long var2, float var4, float var5, long var6, long var8);

        public static native boolean setPosition(long var0, long var2);

        public static native long getPosition(long var0);

        public static native boolean setFootPosition(long var0, long var2);

        public static native long getFootPosition(long var0);

        public static native long getActor(long var0);

        public static native void setStepOffset(long var0, float var2);

        public static native float getStepOffset(long var0);

        public static native void setNonWalkableMode(long var0, int var2);

        public static native int getNonWalkableMode(long var0);

        public static native float getContactOffset(long var0);

        public static native void setContactOffset(long var0, float var2);

        public static native long getUpDirection(long var0);

        public static native void setUpDirection(long var0, long var2);

        public static native float getSlopeLimit(long var0);

        public static native void setSlopeLimit(long var0, float var2);

        public static native void invalidateCache(long var0);

        public static native long getScene(long var0);

        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native void getState(long var0, long var2);

        public static native void getStats(long var0, long var2);

        public static native void resize(long var0, float var2);
    }
}

