package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDParameters extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDParameters");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static VHACDParameters wrapPointer(long address) {
        return address != 0L ? new VHACDParameters(address) : null;
    }
    
    public static VHACDParameters arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected VHACDParameters(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of VHACDParameters
     */
    public static VHACDParameters createAt(long address) {
        __placement_new_VHACDParameters(address);
        VHACDParameters createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of VHACDParameters
     */
    public static <T> VHACDParameters createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_VHACDParameters(address);
        VHACDParameters createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_VHACDParameters(long address);

    // Constructors

    public VHACDParameters() {
        address = _VHACDParameters();
    }
    private static native long _VHACDParameters();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_maxConvexHulls() {
        checkNotNull();
        return _getM_maxConvexHulls(address);
    }
    private static native int _getM_maxConvexHulls(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_maxConvexHulls(int value) {
        checkNotNull();
        _setM_maxConvexHulls(address, value);
    }
    private static native void _setM_maxConvexHulls(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_resolution() {
        checkNotNull();
        return _getM_resolution(address);
    }
    private static native int _getM_resolution(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_resolution(int value) {
        checkNotNull();
        _setM_resolution(address, value);
    }
    private static native void _setM_resolution(long address, int value);

    /**
     * @return WebIDL type: double
     */
    public double getM_minimumVolumePercentErrorAllowed() {
        checkNotNull();
        return _getM_minimumVolumePercentErrorAllowed(address);
    }
    private static native double _getM_minimumVolumePercentErrorAllowed(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setM_minimumVolumePercentErrorAllowed(double value) {
        checkNotNull();
        _setM_minimumVolumePercentErrorAllowed(address, value);
    }
    private static native void _setM_minimumVolumePercentErrorAllowed(long address, double value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_maxRecursionDepth() {
        checkNotNull();
        return _getM_maxRecursionDepth(address);
    }
    private static native int _getM_maxRecursionDepth(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_maxRecursionDepth(int value) {
        checkNotNull();
        _setM_maxRecursionDepth(address, value);
    }
    private static native void _setM_maxRecursionDepth(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getM_shrinkWrap() {
        checkNotNull();
        return _getM_shrinkWrap(address);
    }
    private static native boolean _getM_shrinkWrap(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setM_shrinkWrap(boolean value) {
        checkNotNull();
        _setM_shrinkWrap(address, value);
    }
    private static native void _setM_shrinkWrap(long address, boolean value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_maxNumVerticesPerCH() {
        checkNotNull();
        return _getM_maxNumVerticesPerCH(address);
    }
    private static native int _getM_maxNumVerticesPerCH(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_maxNumVerticesPerCH(int value) {
        checkNotNull();
        _setM_maxNumVerticesPerCH(address, value);
    }
    private static native void _setM_maxNumVerticesPerCH(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getM_asyncACD() {
        checkNotNull();
        return _getM_asyncACD(address);
    }
    private static native boolean _getM_asyncACD(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setM_asyncACD(boolean value) {
        checkNotNull();
        _setM_asyncACD(address, value);
    }
    private static native void _setM_asyncACD(long address, boolean value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_minEdgeLength() {
        checkNotNull();
        return _getM_minEdgeLength(address);
    }
    private static native int _getM_minEdgeLength(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_minEdgeLength(int value) {
        checkNotNull();
        _setM_minEdgeLength(address, value);
    }
    private static native void _setM_minEdgeLength(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getM_findBestPlane() {
        checkNotNull();
        return _getM_findBestPlane(address);
    }
    private static native boolean _getM_findBestPlane(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setM_findBestPlane(boolean value) {
        checkNotNull();
        _setM_findBestPlane(address, value);
    }
    private static native void _setM_findBestPlane(long address, boolean value);

}
