package physx.vehicle2;

import physx.NativeObject;

/**
 * PxVehicleMultiWheelDriveDifferentialParams specifies the wheels that are to receive drive torque from the differential 
 * and the division of torque between the wheels that are connected to the differential. 
 */
public class PxVehicleMultiWheelDriveDifferentialParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleMultiWheelDriveDifferentialParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleMultiWheelDriveDifferentialParams(address) : null;
    }
    
    public static PxVehicleMultiWheelDriveDifferentialParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleMultiWheelDriveDifferentialParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleMultiWheelDriveDifferentialParams
     */
    public static PxVehicleMultiWheelDriveDifferentialParams createAt(long address) {
        __placement_new_PxVehicleMultiWheelDriveDifferentialParams(address);
        PxVehicleMultiWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleMultiWheelDriveDifferentialParams
     */
    public static <T> PxVehicleMultiWheelDriveDifferentialParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleMultiWheelDriveDifferentialParams(address);
        PxVehicleMultiWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleMultiWheelDriveDifferentialParams(long address);

    // Constructors

    public PxVehicleMultiWheelDriveDifferentialParams() {
        address = _PxVehicleMultiWheelDriveDifferentialParams();
    }
    private static native long _PxVehicleMultiWheelDriveDifferentialParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getTorqueRatios(int index) {
        checkNotNull();
        return _getTorqueRatios(address, index);
    }
    private static native float _getTorqueRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setTorqueRatios(int index, float value) {
        checkNotNull();
        _setTorqueRatios(address, index, value);
    }
    private static native void _setTorqueRatios(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getAveWheelSpeedRatios(int index) {
        checkNotNull();
        return _getAveWheelSpeedRatios(address, index);
    }
    private static native float _getAveWheelSpeedRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setAveWheelSpeedRatios(int index, float value) {
        checkNotNull();
        _setAveWheelSpeedRatios(address, index, value);
    }
    private static native void _setAveWheelSpeedRatios(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleMultiWheelDriveDifferentialParams} [Value]
     */
    public PxVehicleMultiWheelDriveDifferentialParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleMultiWheelDriveDifferentialParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

}
