package physx.vehicle2;

import physx.physics.PxConstraintConnector;

public class PxVehicleConstraintConnector extends PxConstraintConnector {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleConstraintConnector wrapPointer(long address) {
        return address != 0L ? new PxVehicleConstraintConnector(address) : null;
    }
    
    public static PxVehicleConstraintConnector arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleConstraintConnector(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleConstraintConnector() {
        address = _PxVehicleConstraintConnector();
    }
    private static native long _PxVehicleConstraintConnector();

    /**
     * @param vehicleConstraintState WebIDL type: {@link PxVehiclePhysXConstraintState}
     */
    public PxVehicleConstraintConnector(PxVehiclePhysXConstraintState vehicleConstraintState) {
        address = _PxVehicleConstraintConnector(vehicleConstraintState.getAddress());
    }
    private static native long _PxVehicleConstraintConnector(long vehicleConstraintState);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param constraintState WebIDL type: {@link PxVehiclePhysXConstraintState}
     */
    public void setConstraintState(PxVehiclePhysXConstraintState constraintState) {
        checkNotNull();
        _setConstraintState(address, constraintState.getAddress());
    }
    private static native void _setConstraintState(long address, long constraintState);

    public void getConstantBlock() {
        checkNotNull();
        _getConstantBlock(address);
    }
    private static native void _getConstantBlock(long address);

}
