package physx.vehicle2;

import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;

public class PhysXActorVehicle extends BaseVehicle {

    protected PhysXActorVehicle() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PhysXActorVehicle wrapPointer(long address) {
        return address != 0L ? new PhysXActorVehicle(address) : null;
    }
    
    public static PhysXActorVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PhysXActorVehicle(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PhysXIntegrationParams} [Value]
     */
    public PhysXIntegrationParams getPhysXParams() {
        checkNotNull();
        return PhysXIntegrationParams.wrapPointer(_getPhysXParams(address));
    }
    private static native long _getPhysXParams(long address);

    /**
     * @param value WebIDL type: {@link PhysXIntegrationParams} [Value]
     */
    public void setPhysXParams(PhysXIntegrationParams value) {
        checkNotNull();
        _setPhysXParams(address, value.getAddress());
    }
    private static native void _setPhysXParams(long address, long value);

    /**
     * @return WebIDL type: {@link PhysXIntegrationState} [Value]
     */
    public PhysXIntegrationState getPhysXState() {
        checkNotNull();
        return PhysXIntegrationState.wrapPointer(_getPhysXState(address));
    }
    private static native long _getPhysXState(long address);

    /**
     * @param value WebIDL type: {@link PhysXIntegrationState} [Value]
     */
    public void setPhysXState(PhysXIntegrationState value) {
        checkNotNull();
        _setPhysXState(address, value.getAddress());
    }
    private static native void _setPhysXState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleCommandState} [Value]
     */
    public PxVehicleCommandState getCommandState() {
        checkNotNull();
        return PxVehicleCommandState.wrapPointer(_getCommandState(address));
    }
    private static native long _getCommandState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleCommandState} [Value]
     */
    public void setCommandState(PxVehicleCommandState value) {
        checkNotNull();
        _setCommandState(address, value.getAddress());
    }
    private static native void _setCommandState(long address, long value);

    // Functions

    /**
     * @param physics         WebIDL type: {@link PxPhysics} [Ref]
     * @param params          WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial WebIDL type: {@link PxMaterial} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial) {
        checkNotNull();
        return _initialize(address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress());
    }
    private static native boolean _initialize(long address, long physics, long params, long defaultMaterial);

}
