package physx.vehicle2;

import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;

public class EngineDriveVehicle extends PhysXActorVehicle {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static EngineDriveVehicle wrapPointer(long address) {
        return address != 0L ? new EngineDriveVehicle(address) : null;
    }
    
    public static EngineDriveVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected EngineDriveVehicle(long address) {
        super(address);
    }

    // Constructors

    public EngineDriveVehicle() {
        address = _EngineDriveVehicle();
    }
    private static native long _EngineDriveVehicle();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link EngineDrivetrainParams} [Value]
     */
    public EngineDrivetrainParams getEngineDriveParams() {
        checkNotNull();
        return EngineDrivetrainParams.wrapPointer(_getEngineDriveParams(address));
    }
    private static native long _getEngineDriveParams(long address);

    /**
     * @param value WebIDL type: {@link EngineDrivetrainParams} [Value]
     */
    public void setEngineDriveParams(EngineDrivetrainParams value) {
        checkNotNull();
        _setEngineDriveParams(address, value.getAddress());
    }
    private static native void _setEngineDriveParams(long address, long value);

    /**
     * @return WebIDL type: {@link EngineDrivetrainState} [Value]
     */
    public EngineDrivetrainState getEngineDriveState() {
        checkNotNull();
        return EngineDrivetrainState.wrapPointer(_getEngineDriveState(address));
    }
    private static native long _getEngineDriveState(long address);

    /**
     * @param value WebIDL type: {@link EngineDrivetrainState} [Value]
     */
    public void setEngineDriveState(EngineDrivetrainState value) {
        checkNotNull();
        _setEngineDriveState(address, value.getAddress());
    }
    private static native void _setEngineDriveState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleEngineDriveTransmissionCommandState} [Value]
     */
    public PxVehicleEngineDriveTransmissionCommandState getTransmissionCommandState() {
        checkNotNull();
        return PxVehicleEngineDriveTransmissionCommandState.wrapPointer(_getTransmissionCommandState(address));
    }
    private static native long _getTransmissionCommandState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleEngineDriveTransmissionCommandState} [Value]
     */
    public void setTransmissionCommandState(PxVehicleEngineDriveTransmissionCommandState value) {
        checkNotNull();
        _setTransmissionCommandState(address, value.getAddress());
    }
    private static native void _setTransmissionCommandState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleTankDriveTransmissionCommandState} [Value]
     */
    public PxVehicleTankDriveTransmissionCommandState getTankDriveTransmissionCommandState() {
        checkNotNull();
        return PxVehicleTankDriveTransmissionCommandState.wrapPointer(_getTankDriveTransmissionCommandState(address));
    }
    private static native long _getTankDriveTransmissionCommandState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleTankDriveTransmissionCommandState} [Value]
     */
    public void setTankDriveTransmissionCommandState(PxVehicleTankDriveTransmissionCommandState value) {
        checkNotNull();
        _setTankDriveTransmissionCommandState(address, value.getAddress());
    }
    private static native void _setTankDriveTransmissionCommandState(long address, long value);

    /**
     * @return WebIDL type: {@link EngineDriveVehicleEnum} [enum]
     */
    public EngineDriveVehicleEnum getDifferentialType() {
        checkNotNull();
        return EngineDriveVehicleEnum.forValue(_getDifferentialType(address));
    }
    private static native int _getDifferentialType(long address);

    /**
     * @param value WebIDL type: {@link EngineDriveVehicleEnum} [enum]
     */
    public void setDifferentialType(EngineDriveVehicleEnum value) {
        checkNotNull();
        _setDifferentialType(address, value.value);
    }
    private static native void _setDifferentialType(long address, int value);

    // Functions

    /**
     * @param physics          WebIDL type: {@link PxPhysics} [Ref]
     * @param params           WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial  WebIDL type: {@link PxMaterial} [Ref]
     * @param differentialType WebIDL type: {@link EngineDriveVehicleEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial, EngineDriveVehicleEnum differentialType) {
        checkNotNull();
        return _initialize(address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress(), differentialType.value);
    }
    private static native boolean _initialize(long address, long physics, long params, long defaultMaterial, int differentialType);

    /**
     * @param physics                    WebIDL type: {@link PxPhysics} [Ref]
     * @param params                     WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial            WebIDL type: {@link PxMaterial} [Ref]
     * @param differentialType           WebIDL type: {@link EngineDriveVehicleEnum} [enum]
     * @param addPhysXBeginEndComponents WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial, EngineDriveVehicleEnum differentialType, boolean addPhysXBeginEndComponents) {
        checkNotNull();
        return _initialize(address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress(), differentialType.value, addPhysXBeginEndComponents);
    }
    private static native boolean _initialize(long address, long physics, long params, long defaultMaterial, int differentialType, boolean addPhysXBeginEndComponents);

    /**
     * @param addPhysXBeginEndComponents WebIDL type: boolean
     */
    public void initComponentSequence(boolean addPhysXBeginEndComponents) {
        checkNotNull();
        _initComponentSequence(address, addPhysXBeginEndComponents);
    }
    private static native void _initComponentSequence(long address, boolean addPhysXBeginEndComponents);

}
