package physx.vehicle2;

import physx.NativeObject;

public class BaseVehicleParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static BaseVehicleParams wrapPointer(long address) {
        return address != 0L ? new BaseVehicleParams(address) : null;
    }
    
    public static BaseVehicleParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected BaseVehicleParams(long address) {
        super(address);
    }

    // Constructors

    public BaseVehicleParams() {
        address = _BaseVehicleParams();
    }
    private static native long _BaseVehicleParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleAxleDescription} [Value]
     */
    public PxVehicleAxleDescription getAxleDescription() {
        checkNotNull();
        return PxVehicleAxleDescription.wrapPointer(_getAxleDescription(address));
    }
    private static native long _getAxleDescription(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleAxleDescription} [Value]
     */
    public void setAxleDescription(PxVehicleAxleDescription value) {
        checkNotNull();
        _setAxleDescription(address, value.getAddress());
    }
    private static native void _setAxleDescription(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleFrame} [Value]
     */
    public PxVehicleFrame getFrame() {
        checkNotNull();
        return PxVehicleFrame.wrapPointer(_getFrame(address));
    }
    private static native long _getFrame(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFrame} [Value]
     */
    public void setFrame(PxVehicleFrame value) {
        checkNotNull();
        _setFrame(address, value.getAddress());
    }
    private static native void _setFrame(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleScale} [Value]
     */
    public PxVehicleScale getScale() {
        checkNotNull();
        return PxVehicleScale.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleScale} [Value]
     */
    public void setScale(PxVehicleScale value) {
        checkNotNull();
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleSuspensionStateCalculationParams} [Value]
     */
    public PxVehicleSuspensionStateCalculationParams getSuspensionStateCalculationParams() {
        checkNotNull();
        return PxVehicleSuspensionStateCalculationParams.wrapPointer(_getSuspensionStateCalculationParams(address));
    }
    private static native long _getSuspensionStateCalculationParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleSuspensionStateCalculationParams} [Value]
     */
    public void setSuspensionStateCalculationParams(PxVehicleSuspensionStateCalculationParams value) {
        checkNotNull();
        _setSuspensionStateCalculationParams(address, value.getAddress());
    }
    private static native void _setSuspensionStateCalculationParams(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleBrakeCommandResponseParams} [Value]
     */
    public PxVehicleBrakeCommandResponseParams getBrakeResponseParams(int index) {
        checkNotNull();
        return PxVehicleBrakeCommandResponseParams.wrapPointer(_getBrakeResponseParams(address, index));
    }
    private static native long _getBrakeResponseParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleBrakeCommandResponseParams} [Value]
     */
    public void setBrakeResponseParams(int index, PxVehicleBrakeCommandResponseParams value) {
        checkNotNull();
        _setBrakeResponseParams(address, index, value.getAddress());
    }
    private static native void _setBrakeResponseParams(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxVehicleSteerCommandResponseParams} [Value]
     */
    public PxVehicleSteerCommandResponseParams getSteerResponseParams() {
        checkNotNull();
        return PxVehicleSteerCommandResponseParams.wrapPointer(_getSteerResponseParams(address));
    }
    private static native long _getSteerResponseParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleSteerCommandResponseParams} [Value]
     */
    public void setSteerResponseParams(PxVehicleSteerCommandResponseParams value) {
        checkNotNull();
        _setSteerResponseParams(address, value.getAddress());
    }
    private static native void _setSteerResponseParams(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleAckermannParams} [Value]
     */
    public PxVehicleAckermannParams getAckermannParams(int index) {
        checkNotNull();
        return PxVehicleAckermannParams.wrapPointer(_getAckermannParams(address, index));
    }
    private static native long _getAckermannParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleAckermannParams} [Value]
     */
    public void setAckermannParams(int index, PxVehicleAckermannParams value) {
        checkNotNull();
        _setAckermannParams(address, index, value.getAddress());
    }
    private static native void _setAckermannParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionParams} [Value]
     */
    public PxVehicleSuspensionParams getSuspensionParams(int index) {
        checkNotNull();
        return PxVehicleSuspensionParams.wrapPointer(_getSuspensionParams(address, index));
    }
    private static native long _getSuspensionParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionParams} [Value]
     */
    public void setSuspensionParams(int index, PxVehicleSuspensionParams value) {
        checkNotNull();
        _setSuspensionParams(address, index, value.getAddress());
    }
    private static native void _setSuspensionParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionComplianceParams} [Value]
     */
    public PxVehicleSuspensionComplianceParams getSuspensionComplianceParams(int index) {
        checkNotNull();
        return PxVehicleSuspensionComplianceParams.wrapPointer(_getSuspensionComplianceParams(address, index));
    }
    private static native long _getSuspensionComplianceParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionComplianceParams} [Value]
     */
    public void setSuspensionComplianceParams(int index, PxVehicleSuspensionComplianceParams value) {
        checkNotNull();
        _setSuspensionComplianceParams(address, index, value.getAddress());
    }
    private static native void _setSuspensionComplianceParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionForceParams} [Value]
     */
    public PxVehicleSuspensionForceParams getSuspensionForceParams(int index) {
        checkNotNull();
        return PxVehicleSuspensionForceParams.wrapPointer(_getSuspensionForceParams(address, index));
    }
    private static native long _getSuspensionForceParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionForceParams} [Value]
     */
    public void setSuspensionForceParams(int index, PxVehicleSuspensionForceParams value) {
        checkNotNull();
        _setSuspensionForceParams(address, index, value.getAddress());
    }
    private static native void _setSuspensionForceParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleAntiRollForceParams} [Value]
     */
    public PxVehicleAntiRollForceParams getAntiRollForceParams(int index) {
        checkNotNull();
        return PxVehicleAntiRollForceParams.wrapPointer(_getAntiRollForceParams(address, index));
    }
    private static native long _getAntiRollForceParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleAntiRollForceParams} [Value]
     */
    public void setAntiRollForceParams(int index, PxVehicleAntiRollForceParams value) {
        checkNotNull();
        _setAntiRollForceParams(address, index, value.getAddress());
    }
    private static native void _setAntiRollForceParams(long address, int index, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAntiRollForceParams() {
        checkNotNull();
        return _getNbAntiRollForceParams(address);
    }
    private static native int _getNbAntiRollForceParams(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbAntiRollForceParams(int value) {
        checkNotNull();
        _setNbAntiRollForceParams(address, value);
    }
    private static native void _setNbAntiRollForceParams(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireForceParams} [Value]
     */
    public PxVehicleTireForceParams getTireForceParams(int index) {
        checkNotNull();
        return PxVehicleTireForceParams.wrapPointer(_getTireForceParams(address, index));
    }
    private static native long _getTireForceParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireForceParams} [Value]
     */
    public void setTireForceParams(int index, PxVehicleTireForceParams value) {
        checkNotNull();
        _setTireForceParams(address, index, value.getAddress());
    }
    private static native void _setTireForceParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleWheelParams} [Value]
     */
    public PxVehicleWheelParams getWheelParams(int index) {
        checkNotNull();
        return PxVehicleWheelParams.wrapPointer(_getWheelParams(address, index));
    }
    private static native long _getWheelParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleWheelParams} [Value]
     */
    public void setWheelParams(int index, PxVehicleWheelParams value) {
        checkNotNull();
        _setWheelParams(address, index, value.getAddress());
    }
    private static native void _setWheelParams(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxVehicleRigidBodyParams} [Value]
     */
    public PxVehicleRigidBodyParams getRigidBodyParams() {
        checkNotNull();
        return PxVehicleRigidBodyParams.wrapPointer(_getRigidBodyParams(address));
    }
    private static native long _getRigidBodyParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleRigidBodyParams} [Value]
     */
    public void setRigidBodyParams(PxVehicleRigidBodyParams value) {
        checkNotNull();
        _setRigidBodyParams(address, value.getAddress());
    }
    private static native void _setRigidBodyParams(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link BaseVehicleParams} [Value]
     */
    public BaseVehicleParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return BaseVehicleParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
