package physx.support;

import physx.NativeObject;

/**
 * PxPvdTransport is an interface representing the data transport mechanism.
 * This class defines all services associated with the transport: configuration, connection, reading, writing etc.
 * It is owned by the application, and can be realized as a file or a socket (using one-line PxDefault&lt;...&gt; methods in
 * PhysXExtensions) or in a custom implementation. This is a class that is intended for use by PVD, not by the
 * application, the application entry points are PxPvd and PvdClient.
 */
public class PxPvdTransport extends NativeObject {

    protected PxPvdTransport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPvdTransport wrapPointer(long address) {
        return address != 0L ? new PxPvdTransport(address) : null;
    }
    
    public static PxPvdTransport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPvdTransport(long address) {
        super(address);
    }

    // Functions

    /**
     * Connects to the Visual Debugger application.
     * return True if success
     */
    public boolean connect() {
        checkNotNull();
        return _connect(address);
    }
    private static native boolean _connect(long address);

    /**
     * * Return if connection to PVD is created.
     */
    public boolean isConnected() {
        checkNotNull();
        return _isConnected(address);
    }
    private static native boolean _isConnected(long address);

    /**
     * Disconnects from the Visual Debugger application.
     * If we are still connected, this will kill the entire debugger connection.
     */
    public void disconnect() {
        checkNotNull();
        _disconnect(address);
    }
    private static native void _disconnect(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * * send any data and block until we know it is at least on the wire.
     */
    public void flush() {
        checkNotNull();
        _flush(address);
    }
    private static native void _flush(long address);

}
