package physx.support;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxOmniPvd extends NativeObject {

    protected PxOmniPvd() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxOmniPvd wrapPointer(long address) {
        return address != 0L ? new PxOmniPvd(address) : null;
    }
    
    public static PxOmniPvd arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxOmniPvd(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link OmniPvdWriter} [Platforms=windows;linux;macos]
     */
    public OmniPvdWriter getWriter() {
        checkNotNull();
        PlatformChecks.requirePlatform(7, "physx.support.PxOmniPvd");
        return OmniPvdWriter.wrapPointer(_getWriter(address));
    }
    private static native long _getWriter(long address);

    /**
     * @return WebIDL type: {@link OmniPvdFileWriteStream} [Platforms=windows;linux;macos]
     */
    public OmniPvdFileWriteStream getFileWriteStream() {
        checkNotNull();
        PlatformChecks.requirePlatform(7, "physx.support.PxOmniPvd");
        return OmniPvdFileWriteStream.wrapPointer(_getFileWriteStream(address));
    }
    private static native long _getFileWriteStream(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean startSampling() {
        checkNotNull();
        return _startSampling(address);
    }
    private static native boolean _startSampling(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
