package physx.support;

import physx.NativeObject;

public class PxArray_PxU8 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxU8 wrapPointer(long address) {
        return address != 0L ? new PxArray_PxU8(address) : null;
    }
    
    public static PxArray_PxU8 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxU8(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxU8
     */
    public static PxArray_PxU8 createAt(long address) {
        __placement_new_PxArray_PxU8(address);
        PxArray_PxU8 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxU8
     */
    public static <T> PxArray_PxU8 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxU8(address);
        PxArray_PxU8 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxU8(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxU8
     */
    public static PxArray_PxU8 createAt(long address, int size) {
        __placement_new_PxArray_PxU8(address, size);
        PxArray_PxU8 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxU8
     */
    public static <T> PxArray_PxU8 createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxU8(address, size);
        PxArray_PxU8 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxU8(long address, int size);

    // Constructors

    public PxArray_PxU8() {
        address = _PxArray_PxU8();
    }
    private static native long _PxArray_PxU8();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxU8(int size) {
        address = _PxArray_PxU8(size);
    }
    private static native long _PxArray_PxU8(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: octet
     */
    public byte get(int index) {
        checkNotNull();
        return _get(address, index);
    }
    private static native byte _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: octet
     */
    public void set(int index, byte value) {
        checkNotNull();
        _set(address, index, value);
    }
    private static native void _set(long address, int index, byte value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject begin() {
        checkNotNull();
        return NativeObject.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void pushBack(byte value) {
        checkNotNull();
        _pushBack(address, value);
    }
    private static native void _pushBack(long address, byte value);

    /**
     * @param buffer WebIDL type: VoidPtr
     * @param size   WebIDL type: unsigned long
     */
    public void setFromBuffer(NativeObject buffer, int size) {
        checkNotNull();
        _setFromBuffer(address, buffer.getAddress(), size);
    }
    private static native void _setFromBuffer(long address, long buffer, int size);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
