package physx.physics;

import physx.NativeObject;

/**
 * Expresses the dominance relationship of a contact.
 * For the time being only three settings are permitted:
 * <p>
 * (1, 1), (0, 1), and (1, 0).
 */
public class PxDominanceGroupPair extends NativeObject {

    protected PxDominanceGroupPair() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDominanceGroupPair wrapPointer(long address) {
        return address != 0L ? new PxDominanceGroupPair(address) : null;
    }
    
    public static PxDominanceGroupPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDominanceGroupPair(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param a WebIDL type: octet
     * @param b WebIDL type: octet
     */
    public PxDominanceGroupPair(byte a, byte b) {
        address = _PxDominanceGroupPair(a, b);
    }
    private static native long _PxDominanceGroupPair(byte a, byte b);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public byte getDominance0() {
        checkNotNull();
        return _getDominance0(address);
    }
    private static native byte _getDominance0(long address);

    /**
     */
    public void setDominance0(byte value) {
        checkNotNull();
        _setDominance0(address, value);
    }
    private static native void _setDominance0(long address, byte value);

    /**
     */
    public byte getDominance1() {
        checkNotNull();
        return _getDominance1(address);
    }
    private static native byte _getDominance1(long address);

    /**
     */
    public void setDominance1(byte value) {
        checkNotNull();
        _setDominance1(address, value);
    }
    private static native void _setDominance1(long address, byte value);

}
