package physx.physics;

/**
 * Identifies each type of actor.
 * <b>See also:</b> PxActor 
 */
public enum PxActorTypeEnum {

    /**
     * A static rigid body
     * <b>See also:</b> PxRigidStatic
     */
    eRIGID_STATIC(geteRIGID_STATIC()),
    /**
     * A dynamic rigid body
     * <b>See also:</b> PxRigidDynamic
     */
    eRIGID_DYNAMIC(geteRIGID_DYNAMIC()),
    /**
     * An articulation link
     * <b>See also:</b> PxArticulationLink
     */
    eARTICULATION_LINK(geteARTICULATION_LINK()),
    /**
     * A deformable surface
     * <b>See also:</b> PxDeformableSurface
     */
    eDEFORMABLE_SURFACE(geteDEFORMABLE_SURFACE()),
    /**
     * A deformable volume
     * <b>See also:</b> PxDeformableVolume
     */
    eDEFORMABLE_VOLUME(geteDEFORMABLE_VOLUME()),
    eSOFTBODY(geteSOFTBODY()),
    /**
     * A PBD ParticleSystem
     * <b>See also:</b> PxPBDParticleSystem
     */
    ePBD_PARTICLESYSTEM(getePBD_PARTICLESYSTEM());
    public final int value;
    
    PxActorTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteRIGID_STATIC();
    private static int geteRIGID_STATIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_STATIC();
    }

    private static native int _geteRIGID_DYNAMIC();
    private static int geteRIGID_DYNAMIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_DYNAMIC();
    }

    private static native int _geteARTICULATION_LINK();
    private static int geteARTICULATION_LINK() {
        de.fabmax.physxjni.Loader.load();
        return _geteARTICULATION_LINK();
    }

    private static native int _geteDEFORMABLE_SURFACE();
    private static int geteDEFORMABLE_SURFACE() {
        de.fabmax.physxjni.Loader.load();
        return _geteDEFORMABLE_SURFACE();
    }

    private static native int _geteDEFORMABLE_VOLUME();
    private static int geteDEFORMABLE_VOLUME() {
        de.fabmax.physxjni.Loader.load();
        return _geteDEFORMABLE_VOLUME();
    }

    private static native int _geteSOFTBODY();
    private static int geteSOFTBODY() {
        de.fabmax.physxjni.Loader.load();
        return _geteSOFTBODY();
    }

    private static native int _getePBD_PARTICLESYSTEM();
    private static int getePBD_PARTICLESYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _getePBD_PARTICLESYSTEM();
    }

    public static PxActorTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxActorTypeEnum: " + value);
    }

}
