package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBounds3;

public class PxParticleVolume extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleVolume");
    }

    protected PxParticleVolume() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleVolume wrapPointer(long address) {
        return address != 0L ? new PxParticleVolume(address) : null;
    }
    
    public static PxParticleVolume arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleVolume(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getBound() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getBound(address));
    }
    private static native long _getBound(long address);

    /**
     * @param value WebIDL type: {@link PxBounds3} [Value]
     */
    public void setBound(PxBounds3 value) {
        checkNotNull();
        _setBound(address, value.getAddress());
    }
    private static native void _setBound(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getParticleIndicesOffset() {
        checkNotNull();
        return _getParticleIndicesOffset(address);
    }
    private static native int _getParticleIndicesOffset(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setParticleIndicesOffset(int value) {
        checkNotNull();
        _setParticleIndicesOffset(address, value);
    }
    private static native void _setParticleIndicesOffset(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumParticles() {
        checkNotNull();
        return _getNumParticles(address);
    }
    private static native int _getNumParticles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNumParticles(int value) {
        checkNotNull();
        _setNumParticles(address, value);
    }
    private static native void _setNumParticles(long address, int value);

}
