package physx.particles;

import physx.PlatformChecks;
import physx.common.PxCudaContextManager;
import physx.physics.PxActor;
import physx.physics.PxFilterData;
import physx.physics.PxRigidActor;

public class PxParticleSystem extends PxActor {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSystem");
    }

    protected PxParticleSystem() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleSystem wrapPointer(long address) {
        return address != 0L ? new PxParticleSystem(address) : null;
    }
    
    public static PxParticleSystem arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleSystem(long address) {
        super(address);
    }

    // Functions

    /**
     * @param minPositionIters WebIDL type: unsigned long
     * @param minVelocityIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getSimulationFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getSimulationFilterData(address));
    }
    private static native long _getSimulationFilterData(long address);

    /**
     * @param data WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setSimulationFilterData(PxFilterData data) {
        checkNotNull();
        _setSimulationFilterData(address, data.getAddress());
    }
    private static native void _setSimulationFilterData(long address, long data);

    /**
     * @param flag WebIDL type: {@link PxParticleFlagEnum} [enum]
     * @param val  WebIDL type: boolean
     */
    public void setParticleFlag(PxParticleFlagEnum flag, boolean val) {
        checkNotNull();
        _setParticleFlag(address, flag.value, val);
    }
    private static native void _setParticleFlag(long address, int flag, boolean val);

    /**
     * @param flags WebIDL type: {@link PxParticleFlags} [Ref]
     */
    public void setParticleFlags(PxParticleFlags flags) {
        checkNotNull();
        _setParticleFlags(address, flags.getAddress());
    }
    private static native void _setParticleFlags(long address, long flags);

    /**
     * @return WebIDL type: {@link PxParticleFlags} [Value]
     */
    public PxParticleFlags getParticleFlags() {
        checkNotNull();
        return PxParticleFlags.wrapPointer(_getParticleFlags(address));
    }
    private static native long _getParticleFlags(long address);

    /**
     * @param maxDepenetrationVelocity WebIDL type: float
     */
    public void setMaxDepenetrationVelocity(float maxDepenetrationVelocity) {
        checkNotNull();
        _setMaxDepenetrationVelocity(address, maxDepenetrationVelocity);
    }
    private static native void _setMaxDepenetrationVelocity(long address, float maxDepenetrationVelocity);

    /**
     * @return WebIDL type: float
     */
    public float getMaxDepenetrationVelocity() {
        checkNotNull();
        return _getMaxDepenetrationVelocity(address);
    }
    private static native float _getMaxDepenetrationVelocity(long address);

    /**
     * @param maxVelocity WebIDL type: float
     */
    public void setMaxVelocity(float maxVelocity) {
        checkNotNull();
        _setMaxVelocity(address, maxVelocity);
    }
    private static native void _setMaxVelocity(long address, float maxVelocity);

    /**
     * @return WebIDL type: float
     */
    public float getMaxVelocity() {
        checkNotNull();
        return _getMaxVelocity(address);
    }
    private static native float _getMaxVelocity(long address);

    /**
     * @return WebIDL type: {@link PxCudaContextManager}
     */
    public PxCudaContextManager getCudaContextManager() {
        checkNotNull();
        return PxCudaContextManager.wrapPointer(_getCudaContextManager(address));
    }
    private static native long _getCudaContextManager(long address);

    /**
     * @param restOffset WebIDL type: float
     */
    public void setRestOffset(float restOffset) {
        checkNotNull();
        _setRestOffset(address, restOffset);
    }
    private static native void _setRestOffset(long address, float restOffset);

    /**
     * @return WebIDL type: float
     */
    public float getRestOffset() {
        checkNotNull();
        return _getRestOffset(address);
    }
    private static native float _getRestOffset(long address);

    /**
     * @param contactOffset WebIDL type: float
     */
    public void setContactOffset(float contactOffset) {
        checkNotNull();
        _setContactOffset(address, contactOffset);
    }
    private static native void _setContactOffset(long address, float contactOffset);

    /**
     * @return WebIDL type: float
     */
    public float getContactOffset() {
        checkNotNull();
        return _getContactOffset(address);
    }
    private static native float _getContactOffset(long address);

    /**
     * @param particleContactOffset WebIDL type: float
     */
    public void setParticleContactOffset(float particleContactOffset) {
        checkNotNull();
        _setParticleContactOffset(address, particleContactOffset);
    }
    private static native void _setParticleContactOffset(long address, float particleContactOffset);

    /**
     * @return WebIDL type: float
     */
    public float getParticleContactOffset() {
        checkNotNull();
        return _getParticleContactOffset(address);
    }
    private static native float _getParticleContactOffset(long address);

    /**
     * @param solidRestOffset WebIDL type: float
     */
    public void setSolidRestOffset(float solidRestOffset) {
        checkNotNull();
        _setSolidRestOffset(address, solidRestOffset);
    }
    private static native void _setSolidRestOffset(long address, float solidRestOffset);

    /**
     * @return WebIDL type: float
     */
    public float getSolidRestOffset() {
        checkNotNull();
        return _getSolidRestOffset(address);
    }
    private static native float _getSolidRestOffset(long address);

    /**
     * @param actor WebIDL type: {@link PxRigidActor}
     */
    public void addRigidAttachment(PxRigidActor actor) {
        checkNotNull();
        _addRigidAttachment(address, actor.getAddress());
    }
    private static native void _addRigidAttachment(long address, long actor);

    /**
     * @param actor WebIDL type: {@link PxRigidActor}
     */
    public void removeRigidAttachment(PxRigidActor actor) {
        checkNotNull();
        _removeRigidAttachment(address, actor.getAddress());
    }
    private static native void _removeRigidAttachment(long address, long actor);

    /**
     * @param enable WebIDL type: boolean
     */
    public void enableCCD(boolean enable) {
        checkNotNull();
        _enableCCD(address, enable);
    }
    private static native void _enableCCD(long address, boolean enable);

    /**
     * @param material WebIDL type: {@link PxParticleMaterial}
     * @param flags    WebIDL type: {@link PxParticlePhaseFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int createPhase(PxParticleMaterial material, PxParticlePhaseFlags flags) {
        checkNotNull();
        return _createPhase(address, material.getAddress(), flags.getAddress());
    }
    private static native int _createPhase(long address, long material, long flags);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbParticleMaterials() {
        checkNotNull();
        return _getNbParticleMaterials(address);
    }
    private static native int _getNbParticleMaterials(long address);

    /**
     * @param callback WebIDL type: {@link PxParticleSystemCallback}
     */
    public void setParticleSystemCallback(PxParticleSystemCallback callback) {
        checkNotNull();
        _setParticleSystemCallback(address, callback.getAddress());
    }
    private static native void _setParticleSystemCallback(long address, long callback);

    /**
     * @return WebIDL type: {@link PxParticleSystemCallback}
     */
    public PxParticleSystemCallback getParticleSystemCallback() {
        checkNotNull();
        return PxParticleSystemCallback.wrapPointer(_getParticleSystemCallback(address));
    }
    private static native long _getParticleSystemCallback(long address);

    /**
     * @param particleBuffer WebIDL type: {@link PxParticleBuffer}
     */
    public void addParticleBuffer(PxParticleBuffer particleBuffer) {
        checkNotNull();
        _addParticleBuffer(address, particleBuffer.getAddress());
    }
    private static native void _addParticleBuffer(long address, long particleBuffer);

    /**
     * @param particleBuffer WebIDL type: {@link PxParticleBuffer}
     */
    public void removeParticleBuffer(PxParticleBuffer particleBuffer) {
        checkNotNull();
        _removeParticleBuffer(address, particleBuffer.getAddress());
    }
    private static native void _removeParticleBuffer(long address, long particleBuffer);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGpuParticleSystemIndex() {
        checkNotNull();
        return _getGpuParticleSystemIndex(address);
    }
    private static native int _getGpuParticleSystemIndex(long address);

}
