package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec4;
import physx.support.PxU32Ptr;

public class PxParticleClothDesc extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothDesc");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothDesc wrapPointer(long address) {
        return address != 0L ? new PxParticleClothDesc(address) : null;
    }
    
    public static PxParticleClothDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleClothDesc
     */
    public static PxParticleClothDesc createAt(long address) {
        __placement_new_PxParticleClothDesc(address);
        PxParticleClothDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleClothDesc
     */
    public static <T> PxParticleClothDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleClothDesc(address);
        PxParticleClothDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleClothDesc(long address);

    // Constructors

    public PxParticleClothDesc() {
        address = _PxParticleClothDesc();
    }
    private static native long _PxParticleClothDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxParticleCloth}
     */
    public PxParticleCloth getCloths() {
        checkNotNull();
        return PxParticleCloth.wrapPointer(_getCloths(address));
    }
    private static native long _getCloths(long address);

    /**
     * @param value WebIDL type: {@link PxParticleCloth}
     */
    public void setCloths(PxParticleCloth value) {
        checkNotNull();
        _setCloths(address, value.getAddress());
    }
    private static native void _setCloths(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getTriangles() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setTriangles(PxU32Ptr value) {
        checkNotNull();
        _setTriangles(address, value.getAddress());
    }
    private static native void _setTriangles(long address, long value);

    /**
     * @return WebIDL type: {@link PxParticleSpring}
     */
    public PxParticleSpring getSprings() {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_getSprings(address));
    }
    private static native long _getSprings(long address);

    /**
     * @param value WebIDL type: {@link PxParticleSpring}
     */
    public void setSprings(PxParticleSpring value) {
        checkNotNull();
        _setSprings(address, value.getAddress());
    }
    private static native void _setSprings(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec4}
     */
    public PxVec4 getRestPositions() {
        checkNotNull();
        return PxVec4.wrapPointer(_getRestPositions(address));
    }
    private static native long _getRestPositions(long address);

    /**
     * @param value WebIDL type: {@link PxVec4}
     */
    public void setRestPositions(PxVec4 value) {
        checkNotNull();
        _setRestPositions(address, value.getAddress());
    }
    private static native void _setRestPositions(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbCloths() {
        checkNotNull();
        return _getNbCloths(address);
    }
    private static native int _getNbCloths(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbCloths(int value) {
        checkNotNull();
        _setNbCloths(address, value);
    }
    private static native void _setNbCloths(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSprings() {
        checkNotNull();
        return _getNbSprings(address);
    }
    private static native int _getNbSprings(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbSprings(int value) {
        checkNotNull();
        _setNbSprings(address, value);
    }
    private static native void _setNbSprings(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTriangles() {
        checkNotNull();
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbTriangles(int value) {
        checkNotNull();
        _setNbTriangles(address, value);
    }
    private static native void _setNbTriangles(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbParticles() {
        checkNotNull();
        return _getNbParticles(address);
    }
    private static native int _getNbParticles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbParticles(int value) {
        checkNotNull();
        _setNbParticles(address, value);
    }
    private static native void _setNbParticles(long address, int value);

}
