package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec4;

public class PxParticleClothBuffer extends PxParticleBuffer {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothBuffer");
    }

    protected PxParticleClothBuffer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothBuffer wrapPointer(long address) {
        return address != 0L ? new PxParticleClothBuffer(address) : null;
    }
    
    public static PxParticleClothBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothBuffer(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxVec4}
     */
    public PxVec4 getRestPositions() {
        checkNotNull();
        return PxVec4.wrapPointer(_getRestPositions(address));
    }
    private static native long _getRestPositions(long address);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getTriangles() {
        checkNotNull();
        return NativeObject.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @param nbTriangles WebIDL type: unsigned long
     */
    public void setNbTriangles(int nbTriangles) {
        checkNotNull();
        _setNbTriangles(address, nbTriangles);
    }
    private static native void _setNbTriangles(long address, int nbTriangles);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTriangles() {
        checkNotNull();
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSprings() {
        checkNotNull();
        return _getNbSprings(address);
    }
    private static native int _getNbSprings(long address);

    /**
     * @return WebIDL type: {@link PxParticleSpring}
     */
    public PxParticleSpring getSprings() {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_getSprings(address));
    }
    private static native long _getSprings(long address);

    /**
     * @param cloths WebIDL type: {@link PxPartitionedParticleCloth} [Ref]
     */
    public void setCloths(PxPartitionedParticleCloth cloths) {
        checkNotNull();
        _setCloths(address, cloths.getAddress());
    }
    private static native void _setCloths(long address, long cloths);

}
