package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxParticleCloth extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleCloth");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleCloth wrapPointer(long address) {
        return address != 0L ? new PxParticleCloth(address) : null;
    }
    
    public static PxParticleCloth arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleCloth(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleCloth
     */
    public static PxParticleCloth createAt(long address) {
        __placement_new_PxParticleCloth(address);
        PxParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleCloth
     */
    public static <T> PxParticleCloth createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleCloth(address);
        PxParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleCloth(long address);

    // Constructors

    public PxParticleCloth() {
        address = _PxParticleCloth();
    }
    private static native long _PxParticleCloth();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStartVertexIndex() {
        checkNotNull();
        return _getStartVertexIndex(address);
    }
    private static native int _getStartVertexIndex(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setStartVertexIndex(int value) {
        checkNotNull();
        _setStartVertexIndex(address, value);
    }
    private static native void _setStartVertexIndex(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumVertices() {
        checkNotNull();
        return _getNumVertices(address);
    }
    private static native int _getNumVertices(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNumVertices(int value) {
        checkNotNull();
        _setNumVertices(address, value);
    }
    private static native void _setNumVertices(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getClothBlendScale() {
        checkNotNull();
        return _getClothBlendScale(address);
    }
    private static native float _getClothBlendScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setClothBlendScale(float value) {
        checkNotNull();
        _setClothBlendScale(address, value);
    }
    private static native void _setClothBlendScale(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRestVolume() {
        checkNotNull();
        return _getRestVolume(address);
    }
    private static native float _getRestVolume(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRestVolume(float value) {
        checkNotNull();
        _setRestVolume(address, value);
    }
    private static native void _setRestVolume(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getPressure() {
        checkNotNull();
        return _getPressure(address);
    }
    private static native float _getPressure(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPressure(float value) {
        checkNotNull();
        _setPressure(address, value);
    }
    private static native void _setPressure(long address, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStartTriangleIndex() {
        checkNotNull();
        return _getStartTriangleIndex(address);
    }
    private static native int _getStartTriangleIndex(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setStartTriangleIndex(int value) {
        checkNotNull();
        _setStartTriangleIndex(address, value);
    }
    private static native void _setStartTriangleIndex(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumTriangles() {
        checkNotNull();
        return _getNumTriangles(address);
    }
    private static native int _getNumTriangles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNumTriangles(int value) {
        checkNotNull();
        _setNumTriangles(address, value);
    }
    private static native void _setNumTriangles(long address, int value);

}
