package physx.geometry;

/**
 * These flags indicate what kind of deficiencies a triangle mesh has and describe if the mesh is considered ok, problematic or invalid for tetmeshing
 */
public enum PxTriangleMeshAnalysisResultEnum {

    eVALID(geteVALID()),
    /**
     * invalid:  Flat mesh without meaningful amount of volume - cannot be meshed since a tetmesh is volumetric
     */
    eZERO_VOLUME(geteZERO_VOLUME()),
    /**
     * problematic: Open boundary means that the mesh is not watertight and that there are holes. The mesher can fill holes but the surface might have an unexpected shape where the hole was.
     */
    eOPEN_BOUNDARIES(geteOPEN_BOUNDARIES()),
    /**
     * problematic: The surface of the resulting mesh won't match exactly at locations of self-intersections. The tetmesh might be connected at self-intersections even if the input triangle mesh is not
     */
    eSELF_INTERSECTIONS(geteSELF_INTERSECTIONS()),
    /**
     * invalid:  It is not possible to distinguish what is inside and outside of the mesh. If there are no self-intersections and not edges shared by more than two triangles, a call to makeTriOrientationConsistent can fix this. Without fixing it, the output from the tetmesher will be incorrect
     */
    eINCONSISTENT_TRIANGLE_ORIENTATION(geteINCONSISTENT_TRIANGLE_ORIENTATION()),
    /**
     * problematic: An ideal mesh for a volume deformable has triangles with similar angles and evenly distributed vertices. Acute angles can be handled but might lead to a poor quality tetmesh.
     */
    eCONTAINS_ACUTE_ANGLED_TRIANGLES(geteCONTAINS_ACUTE_ANGLED_TRIANGLES()),
    /**
     * problematic: Border case of a self-intersecting mesh. The tetmesh might not match the surace exactly near such edges.
     */
    eEDGE_SHARED_BY_MORE_THAN_TWO_TRIANGLES(geteEDGE_SHARED_BY_MORE_THAN_TWO_TRIANGLES()),
    /**
     * ok:   Duplicate points can be handled by the mesher without problems. The resulting tetmesh will only make use of first unique point that is found, duplicate points will get mapped to that unique point in the tetmesh. Therefore the tetmesh can contain points that are not accessed by a tet.
     */
    eCONTAINS_DUPLICATE_POINTS(geteCONTAINS_DUPLICATE_POINTS()),
    /**
     * invalid:  Points contain NAN, infinity or similar values that will lead to an invalid mesh
     */
    eCONTAINS_INVALID_POINTS(geteCONTAINS_INVALID_POINTS()),
    /**
     * invalid:  Mesh contains more indices than a 16bit index buffer can address
     */
    eREQUIRES_32BIT_INDEX_BUFFER(geteREQUIRES_32BIT_INDEX_BUFFER()),
    /**
     * invalid:  A mesh triangle index is negative or lager than the size of the vertex buffer
     */
    eTRIANGLE_INDEX_OUT_OF_RANGE(geteTRIANGLE_INDEX_OUT_OF_RANGE()),
    /**
     * flag is set if the mesh is categorized as problematic
     */
    eMESH_IS_PROBLEMATIC(geteMESH_IS_PROBLEMATIC()),
    eMESH_IS_INVALID(geteMESH_IS_INVALID());
    public final int value;
    
    PxTriangleMeshAnalysisResultEnum(int value) {
        this.value = value;
    }

    private static native int _geteVALID();
    private static int geteVALID() {
        de.fabmax.physxjni.Loader.load();
        return _geteVALID();
    }

    private static native int _geteZERO_VOLUME();
    private static int geteZERO_VOLUME() {
        de.fabmax.physxjni.Loader.load();
        return _geteZERO_VOLUME();
    }

    private static native int _geteOPEN_BOUNDARIES();
    private static int geteOPEN_BOUNDARIES() {
        de.fabmax.physxjni.Loader.load();
        return _geteOPEN_BOUNDARIES();
    }

    private static native int _geteSELF_INTERSECTIONS();
    private static int geteSELF_INTERSECTIONS() {
        de.fabmax.physxjni.Loader.load();
        return _geteSELF_INTERSECTIONS();
    }

    private static native int _geteINCONSISTENT_TRIANGLE_ORIENTATION();
    private static int geteINCONSISTENT_TRIANGLE_ORIENTATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteINCONSISTENT_TRIANGLE_ORIENTATION();
    }

    private static native int _geteCONTAINS_ACUTE_ANGLED_TRIANGLES();
    private static int geteCONTAINS_ACUTE_ANGLED_TRIANGLES() {
        de.fabmax.physxjni.Loader.load();
        return _geteCONTAINS_ACUTE_ANGLED_TRIANGLES();
    }

    private static native int _geteEDGE_SHARED_BY_MORE_THAN_TWO_TRIANGLES();
    private static int geteEDGE_SHARED_BY_MORE_THAN_TWO_TRIANGLES() {
        de.fabmax.physxjni.Loader.load();
        return _geteEDGE_SHARED_BY_MORE_THAN_TWO_TRIANGLES();
    }

    private static native int _geteCONTAINS_DUPLICATE_POINTS();
    private static int geteCONTAINS_DUPLICATE_POINTS() {
        de.fabmax.physxjni.Loader.load();
        return _geteCONTAINS_DUPLICATE_POINTS();
    }

    private static native int _geteCONTAINS_INVALID_POINTS();
    private static int geteCONTAINS_INVALID_POINTS() {
        de.fabmax.physxjni.Loader.load();
        return _geteCONTAINS_INVALID_POINTS();
    }

    private static native int _geteREQUIRES_32BIT_INDEX_BUFFER();
    private static int geteREQUIRES_32BIT_INDEX_BUFFER() {
        de.fabmax.physxjni.Loader.load();
        return _geteREQUIRES_32BIT_INDEX_BUFFER();
    }

    private static native int _geteTRIANGLE_INDEX_OUT_OF_RANGE();
    private static int geteTRIANGLE_INDEX_OUT_OF_RANGE() {
        de.fabmax.physxjni.Loader.load();
        return _geteTRIANGLE_INDEX_OUT_OF_RANGE();
    }

    private static native int _geteMESH_IS_PROBLEMATIC();
    private static int geteMESH_IS_PROBLEMATIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteMESH_IS_PROBLEMATIC();
    }

    private static native int _geteMESH_IS_INVALID();
    private static int geteMESH_IS_INVALID() {
        de.fabmax.physxjni.Loader.load();
        return _geteMESH_IS_INVALID();
    }

    public static PxTriangleMeshAnalysisResultEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxTriangleMeshAnalysisResultEnum: " + value);
    }

}
