package physx.geometry;

import physx.NativeObject;

public class PxTetrahedronMeshAnalysisResults extends NativeObject {

    protected PxTetrahedronMeshAnalysisResults() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTetrahedronMeshAnalysisResults wrapPointer(long address) {
        return address != 0L ? new PxTetrahedronMeshAnalysisResults(address) : null;
    }
    
    public static PxTetrahedronMeshAnalysisResults arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTetrahedronMeshAnalysisResults(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned long
     * @return Stack allocated object of PxTetrahedronMeshAnalysisResults
     */
    public static PxTetrahedronMeshAnalysisResults createAt(long address, int flags) {
        __placement_new_PxTetrahedronMeshAnalysisResults(address, flags);
        PxTetrahedronMeshAnalysisResults createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned long
     * @return Stack allocated object of PxTetrahedronMeshAnalysisResults
     */
    public static <T> PxTetrahedronMeshAnalysisResults createAt(T allocator, Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTetrahedronMeshAnalysisResults(address, flags);
        PxTetrahedronMeshAnalysisResults createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTetrahedronMeshAnalysisResults(long address, int flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxTetrahedronMeshAnalysisResults(int flags) {
        address = _PxTetrahedronMeshAnalysisResults(flags);
    }
    private static native long _PxTetrahedronMeshAnalysisResults(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxTetrahedronMeshAnalysisResultEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxTetrahedronMeshAnalysisResultEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxTetrahedronMeshAnalysisResultEnum} [enum]
     */
    public void raise(PxTetrahedronMeshAnalysisResultEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxTetrahedronMeshAnalysisResultEnum} [enum]
     */
    public void clear(PxTetrahedronMeshAnalysisResultEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
