package physx.extensions;


/**
 * Pre-made support mapping for a sphere
 */
public class SphereSupport extends Support {

    protected SphereSupport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SphereSupport wrapPointer(long address) {
        return address != 0L ? new SphereSupport(address) : null;
    }
    
    public static SphereSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SphereSupport(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param radius  WebIDL type: float
     * @return Stack allocated object of SphereSupport
     */
    public static SphereSupport createAt(long address, float radius) {
        __placement_new_SphereSupport(address, radius);
        SphereSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param radius    WebIDL type: float
     * @return Stack allocated object of SphereSupport
     */
    public static <T> SphereSupport createAt(T allocator, Allocator<T> allocate, float radius) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_SphereSupport(address, radius);
        SphereSupport createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_SphereSupport(long address, float radius);

    // Constructors

    /**
     * Constructs a SphereSupport for a sphere radius
     */
    public SphereSupport(float radius) {
        address = _SphereSupport(radius);
    }
    private static native long _SphereSupport(float radius);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

}
