package physx.extensions;

import physx.NativeObject;

public class PxSpring extends NativeObject {

    protected PxSpring() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSpring wrapPointer(long address) {
        return address != 0L ? new PxSpring(address) : null;
    }
    
    public static PxSpring arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSpring(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address   Pre-allocated memory, where the object is created.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @return Stack allocated object of PxSpring
     */
    public static PxSpring createAt(long address, float stiffness, float damping) {
        __placement_new_PxSpring(address, stiffness, damping);
        PxSpring createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @return Stack allocated object of PxSpring
     */
    public static <T> PxSpring createAt(T allocator, Allocator<T> allocate, float stiffness, float damping) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSpring(address, stiffness, damping);
        PxSpring createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSpring(long address, float stiffness, float damping);

    // Constructors

    /**
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     */
    public PxSpring(float stiffness, float damping) {
        address = _PxSpring(stiffness, damping);
    }
    private static native long _PxSpring(float stiffness, float damping);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * the spring strength of the drive: that is, the force proportional to the position error
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * the spring strength of the drive: that is, the force proportional to the position error
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * the damping strength of the drive: that is, the force proportional to the velocity error
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * the damping strength of the drive: that is, the force proportional to the velocity error
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

}
