package physx.extensions;


/**
 * Describes an elliptical conical joint limit. Note that very small or highly elliptical limit cones may 
 * result in jitter.
 * @see PxD6Joint
 * @see PxSphericalJoint
 */
public class PxJointLimitCone extends PxJointLimitParameters {

    protected PxJointLimitCone() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointLimitCone wrapPointer(long address) {
        return address != 0L ? new PxJointLimitCone(address) : null;
    }
    
    public static PxJointLimitCone arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointLimitCone(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address     Pre-allocated memory, where the object is created.
     * @param yLimitAngle WebIDL type: float
     * @param zLimitAngle WebIDL type: float
     * @return Stack allocated object of PxJointLimitCone
     */
    public static PxJointLimitCone createAt(long address, float yLimitAngle, float zLimitAngle) {
        __placement_new_PxJointLimitCone(address, yLimitAngle, zLimitAngle);
        PxJointLimitCone createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>         Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator   Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate    Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param yLimitAngle WebIDL type: float
     * @param zLimitAngle WebIDL type: float
     * @return Stack allocated object of PxJointLimitCone
     */
    public static <T> PxJointLimitCone createAt(T allocator, Allocator<T> allocate, float yLimitAngle, float zLimitAngle) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointLimitCone(address, yLimitAngle, zLimitAngle);
        PxJointLimitCone createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointLimitCone(long address, float yLimitAngle, float zLimitAngle);

    /**
     * @param address     Pre-allocated memory, where the object is created.
     * @param yLimitAngle WebIDL type: float
     * @param zLimitAngle WebIDL type: float
     * @param spring      WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointLimitCone
     */
    public static PxJointLimitCone createAt(long address, float yLimitAngle, float zLimitAngle, PxSpring spring) {
        __placement_new_PxJointLimitCone(address, yLimitAngle, zLimitAngle, spring.getAddress());
        PxJointLimitCone createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>         Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator   Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate    Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param yLimitAngle WebIDL type: float
     * @param zLimitAngle WebIDL type: float
     * @param spring      WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointLimitCone
     */
    public static <T> PxJointLimitCone createAt(T allocator, Allocator<T> allocate, float yLimitAngle, float zLimitAngle, PxSpring spring) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointLimitCone(address, yLimitAngle, zLimitAngle, spring.getAddress());
        PxJointLimitCone createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointLimitCone(long address, float yLimitAngle, float zLimitAngle, long spring);

    // Constructors

    /**
     * Construct a cone hard limit. 
     * @param yLimitAngle The limit angle from the Y-axis of the constraint frame
     * @param zLimitAngle The limit angle from the Z-axis of the constraint frame
     * @see PxJointLimitParameters
     */
    public PxJointLimitCone(float yLimitAngle, float zLimitAngle) {
        address = _PxJointLimitCone(yLimitAngle, zLimitAngle);
    }
    private static native long _PxJointLimitCone(float yLimitAngle, float zLimitAngle);

    /**
     * Construct a cone soft limit. 
     * @param yLimitAngle The limit angle from the Y-axis of the constraint frame
     * @param zLimitAngle The limit angle from the Z-axis of the constraint frame
     * @param spring  The stiffness and damping of the limit spring
     * @see PxJointLimitParameters
     */
    public PxJointLimitCone(float yLimitAngle, float zLimitAngle, PxSpring spring) {
        address = _PxJointLimitCone(yLimitAngle, zLimitAngle, spring.getAddress());
    }
    private static native long _PxJointLimitCone(float yLimitAngle, float zLimitAngle, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * the maximum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (0,PI)<br>
     * <b>Default:</b> PI/2
     */
    public float getYAngle() {
        checkNotNull();
        return _getYAngle(address);
    }
    private static native float _getYAngle(long address);

    /**
     * the maximum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (0,PI)<br>
     * <b>Default:</b> PI/2
     */
    public void setYAngle(float value) {
        checkNotNull();
        _setYAngle(address, value);
    }
    private static native void _setYAngle(long address, float value);

    /**
     * the maximum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (0,PI)<br>
     * <b>Default:</b> PI/2
     */
    public float getZAngle() {
        checkNotNull();
        return _getZAngle(address);
    }
    private static native float _getZAngle(long address);

    /**
     * the maximum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (0,PI)<br>
     * <b>Default:</b> PI/2
     */
    public void setZAngle(float value) {
        checkNotNull();
        _setZAngle(address, value);
    }
    private static native void _setZAngle(long address, float value);

}
