package physx.extensions;

import physx.NativeObject;
import physx.common.PxInputData;
import physx.support.PxU8Ptr;

/**
 * default implementation of a memory read stream
 * @see physx.common.PxInputData
 */
public class PxDefaultMemoryInputData extends PxInputData {

    protected PxDefaultMemoryInputData() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDefaultMemoryInputData wrapPointer(long address) {
        return address != 0L ? new PxDefaultMemoryInputData(address) : null;
    }
    
    public static PxDefaultMemoryInputData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDefaultMemoryInputData(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param data   WebIDL type: {@link PxU8Ptr} [Ref]
     * @param length WebIDL type: unsigned long
     */
    public PxDefaultMemoryInputData(PxU8Ptr data, int length) {
        address = _PxDefaultMemoryInputData(data.getAddress(), length);
    }
    private static native long _PxDefaultMemoryInputData(long data, int length);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param dest  WebIDL type: VoidPtr
     * @param count WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int read(NativeObject dest, int count) {
        checkNotNull();
        return _read(address, dest.getAddress(), count);
    }
    private static native int _read(long address, long dest, int count);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getLength() {
        checkNotNull();
        return _getLength(address);
    }
    private static native int _getLength(long address);

    /**
     * @param pos WebIDL type: unsigned long
     */
    public void seek(int pos) {
        checkNotNull();
        _seek(address, pos);
    }
    private static native void _seek(long address, int pos);

    /**
     * @return WebIDL type: unsigned long
     */
    public int tell() {
        checkNotNull();
        return _tell(address);
    }
    private static native int _tell(long address);

}
