package physx.extensions;

/**
 * flags for configuring the drive model of a PxD6Joint
 * <p>
 * <b>See also:</b> PxD6JointDrive PxD6Joint
 */
public enum PxD6JointDriveFlagEnum {

    /**
     * drive spring is for the acceleration at the joint (rather than the force)
     */
    eACCELERATION(geteACCELERATION());
    public final int value;
    
    PxD6JointDriveFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteACCELERATION();
    private static int geteACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteACCELERATION();
    }

    public static PxD6JointDriveFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxD6JointDriveFlagEnum: " + value);
    }

}
