package physx.cooking;

import physx.NativeObject;
import physx.common.PxBoundedData;

/**
 * Descriptor class for #PxConvexMesh.
 * <b>Note:</b> The number of vertices and the number of convex polygons in a cooked convex mesh is limited to 256.
 * <b>Note:</b> The number of vertices and the number of convex polygons in a GPU compatible convex mesh is limited to 64,
 * and the number of faces per vertex is limited to 32.
 * @see physx.geometry.PxConvexMesh
 * @see physx.geometry.PxConvexMeshGeometry
 * @see physx.physics.PxShape
 * @see physx.physics.PxPhysics#createConvexMesh
 */
public class PxConvexMeshDesc extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConvexMeshDesc wrapPointer(long address) {
        return address != 0L ? new PxConvexMeshDesc(address) : null;
    }
    
    public static PxConvexMeshDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConvexMeshDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxConvexMeshDesc
     */
    public static PxConvexMeshDesc createAt(long address) {
        __placement_new_PxConvexMeshDesc(address);
        PxConvexMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxConvexMeshDesc
     */
    public static <T> PxConvexMeshDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConvexMeshDesc(address);
        PxConvexMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConvexMeshDesc(long address);

    // Constructors

    /**
     * constructor sets to default.
     */
    public PxConvexMeshDesc() {
        address = _PxConvexMeshDesc();
    }
    private static native long _PxConvexMeshDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Vertex positions data in PxBoundedData format.
     * <p>
     * <b>Default:</b> NULL
     */
    public PxBoundedData getPoints() {
        checkNotNull();
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * Vertex positions data in PxBoundedData format.
     * <p>
     * <b>Default:</b> NULL
     */
    public void setPoints(PxBoundedData value) {
        checkNotNull();
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * Flags bits, combined from values of the enum ::PxConvexFlag
     * <p>
     * <b>Default:</b> 0
     */
    public PxConvexFlags getFlags() {
        checkNotNull();
        return PxConvexFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * Flags bits, combined from values of the enum ::PxConvexFlag
     * <p>
     * <b>Default:</b> 0
     */
    public void setFlags(PxConvexFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
