package physx.common;

import physx.NativeObject;

/**
 * Used to store a single point and colour for debug rendering.
 */
public class PxDebugPoint extends NativeObject {

    protected PxDebugPoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDebugPoint wrapPointer(long address) {
        return address != 0L ? new PxDebugPoint(address) : null;
    }
    
    public static PxDebugPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDebugPoint(long address) {
        super(address);
    }

    // Attributes

    /**
     */
    public PxVec3 getPos() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPos(address));
    }
    private static native long _getPos(long address);

    /**
     */
    public void setPos(PxVec3 value) {
        checkNotNull();
        _setPos(address, value.getAddress());
    }
    private static native void _setPos(long address, long value);

    /**
     */
    public int getColor() {
        checkNotNull();
        return _getColor(address);
    }
    private static native int _getColor(long address);

    /**
     */
    public void setColor(int value) {
        checkNotNull();
        _setColor(address, value);
    }
    private static native void _setColor(long address, int value);

}
