package physx.common;

import physx.NativeObject;

/**
 * A CpuDispatcher is responsible for scheduling the execution of tasks passed to it by the SDK.
 * <p>
 * A typical implementation would for example use a thread pool with the dispatcher
 * pushing tasks onto worker thread queues or a global queue.
 * @see PxBaseTask
 */
public class PxCpuDispatcher extends NativeObject {

    protected PxCpuDispatcher() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCpuDispatcher wrapPointer(long address) {
        return address != 0L ? new PxCpuDispatcher(address) : null;
    }
    
    public static PxCpuDispatcher arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCpuDispatcher(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
