package physx.character;


/**
 * Describes a hit between a CCT and another CCT. Passed to onControllerHit().
 * @see PxUserControllerHitReport#onControllerHit
 */
public class PxControllersHit extends PxControllerHit {

    protected PxControllersHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllersHit wrapPointer(long address) {
        return address != 0L ? new PxControllersHit(address) : null;
    }
    
    public static PxControllersHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllersHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Touched controller
     */
    public PxController getOther() {
        checkNotNull();
        return PxController.wrapPointer(_getOther(address));
    }
    private static native long _getOther(long address);

    /**
     * Touched controller
     */
    public void setOther(PxController value) {
        checkNotNull();
        _setOther(address, value.getAddress());
    }
    private static native void _setOther(long address, long value);

}
