package physx.character;

import physx.physics.PxRigidActor;
import physx.physics.PxShape;

/**
 * Describes a hit between a CCT and a shape. Passed to onShapeHit()
 * @see PxUserControllerHitReport#onShapeHit
 */
public class PxControllerShapeHit extends PxControllerHit {

    protected PxControllerShapeHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerShapeHit wrapPointer(long address) {
        return address != 0L ? new PxControllerShapeHit(address) : null;
    }
    
    public static PxControllerShapeHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerShapeHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Touched shape
     */
    public PxShape getShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getShape(address));
    }
    private static native long _getShape(long address);

    /**
     * Touched shape
     */
    public void setShape(PxShape value) {
        checkNotNull();
        _setShape(address, value.getAddress());
    }
    private static native void _setShape(long address, long value);

    /**
     * Touched actor
     */
    public PxRigidActor getActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * Touched actor
     */
    public void setActor(PxRigidActor value) {
        checkNotNull();
        _setActor(address, value.getAddress());
    }
    private static native void _setActor(long address, long value);

    /**
     * touched triangle index (only for meshes/heightfields)
     */
    public int getTriangleIndex() {
        checkNotNull();
        return _getTriangleIndex(address);
    }
    private static native int _getTriangleIndex(long address);

    /**
     * touched triangle index (only for meshes/heightfields)
     */
    public void setTriangleIndex(int value) {
        checkNotNull();
        _setTriangleIndex(address, value);
    }
    private static native void _setTriangleIndex(long address, int value);

}
