package physx.character;

import physx.NativeObject;

public class PxControllerCollisionFlags extends NativeObject {

    protected PxControllerCollisionFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerCollisionFlags wrapPointer(long address) {
        return address != 0L ? new PxControllerCollisionFlags(address) : null;
    }
    
    public static PxControllerCollisionFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerCollisionFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: octet
     * @return Stack allocated object of PxControllerCollisionFlags
     */
    public static PxControllerCollisionFlags createAt(long address, byte flags) {
        __placement_new_PxControllerCollisionFlags(address, flags);
        PxControllerCollisionFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: octet
     * @return Stack allocated object of PxControllerCollisionFlags
     */
    public static <T> PxControllerCollisionFlags createAt(T allocator, Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxControllerCollisionFlags(address, flags);
        PxControllerCollisionFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxControllerCollisionFlags(long address, byte flags);

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxControllerCollisionFlags(byte flags) {
        address = _PxControllerCollisionFlags(flags);
    }
    private static native long _PxControllerCollisionFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxControllerCollisionFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxControllerCollisionFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxControllerCollisionFlagEnum} [enum]
     */
    public void raise(PxControllerCollisionFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxControllerCollisionFlagEnum} [enum]
     */
    public void clear(PxControllerCollisionFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
