/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxBaseTask
extends NativeObject {
    public static final int SIZEOF = PxBaseTask.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxBaseTask() {
    }

    private static native int __sizeOf();

    public static PxBaseTask wrapPointer(long address) {
        return address != 0L ? new PxBaseTask(address) : null;
    }

    public static PxBaseTask arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBaseTask.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBaseTask(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxBaseTask._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);
}

