package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDConvexHull extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDConvexHull");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static VHACDConvexHull wrapPointer(long address) {
        return address != 0L ? new VHACDConvexHull(address) : null;
    }
    
    public static VHACDConvexHull arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected VHACDConvexHull(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of VHACDConvexHull
     */
    public static VHACDConvexHull createAt(long address) {
        __placement_new_VHACDConvexHull(address);
        VHACDConvexHull createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of VHACDConvexHull
     */
    public static <T> VHACDConvexHull createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_VHACDConvexHull(address);
        VHACDConvexHull createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_VHACDConvexHull(long address);

    // Constructors

    public VHACDConvexHull() {
        address = _VHACDConvexHull();
    }
    private static native long _VHACDConvexHull();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link Vector_VHACDVertex} [Value]
     */
    public Vector_VHACDVertex getM_points() {
        checkNotNull();
        return Vector_VHACDVertex.wrapPointer(_getM_points(address));
    }
    private static native long _getM_points(long address);

    /**
     * @param value WebIDL type: {@link Vector_VHACDVertex} [Value]
     */
    public void setM_points(Vector_VHACDVertex value) {
        checkNotNull();
        _setM_points(address, value.getAddress());
    }
    private static native void _setM_points(long address, long value);

    /**
     * @return WebIDL type: {@link Vector_VHACDTriangle} [Value]
     */
    public Vector_VHACDTriangle getM_triangles() {
        checkNotNull();
        return Vector_VHACDTriangle.wrapPointer(_getM_triangles(address));
    }
    private static native long _getM_triangles(long address);

    /**
     * @param value WebIDL type: {@link Vector_VHACDTriangle} [Value]
     */
    public void setM_triangles(Vector_VHACDTriangle value) {
        checkNotNull();
        _setM_triangles(address, value.getAddress());
    }
    private static native void _setM_triangles(long address, long value);

    /**
     * @return WebIDL type: double
     */
    public double getM_volume() {
        checkNotNull();
        return _getM_volume(address);
    }
    private static native double _getM_volume(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setM_volume(double value) {
        checkNotNull();
        _setM_volume(address, value);
    }
    private static native void _setM_volume(long address, double value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getM_meshId() {
        checkNotNull();
        return _getM_meshId(address);
    }
    private static native int _getM_meshId(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setM_meshId(int value) {
        checkNotNull();
        _setM_meshId(address, value);
    }
    private static native void _setM_meshId(long address, int value);

}
