package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of the per wheel response to an input command.
 */
public class PxVehicleCommandResponseParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleCommandResponseParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleCommandResponseParams(address) : null;
    }
    
    public static PxVehicleCommandResponseParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleCommandResponseParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleCommandResponseParams() {
        address = _PxVehicleCommandResponseParams();
    }
    private static native long _PxVehicleCommandResponseParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * A nonlinear response to command value expressed as a lookup table of normalized response as a function of command value and longitudinal speed.
     * <b>Note:</b> The effect of the default state of nonlinearResponse is a linear response to command value that is independent of longitudinal speed.
     */
    public PxVehicleCommandNonLinearResponseParams getNonlinearResponse() {
        checkNotNull();
        return PxVehicleCommandNonLinearResponseParams.wrapPointer(_getNonlinearResponse(address));
    }
    private static native long _getNonlinearResponse(long address);

    /**
     * A nonlinear response to command value expressed as a lookup table of normalized response as a function of command value and longitudinal speed.
     * <b>Note:</b> The effect of the default state of nonlinearResponse is a linear response to command value that is independent of longitudinal speed.
     */
    public void setNonlinearResponse(PxVehicleCommandNonLinearResponseParams value) {
        checkNotNull();
        _setNonlinearResponse(address, value.getAddress());
    }
    private static native void _setNonlinearResponse(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getWheelResponseMultipliers(int index) {
        checkNotNull();
        return _getWheelResponseMultipliers(address, index);
    }
    private static native float _getWheelResponseMultipliers(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setWheelResponseMultipliers(int index, float value) {
        checkNotNull();
        _setWheelResponseMultipliers(address, index, value);
    }
    private static native void _setWheelResponseMultipliers(long address, int index, float value);

    /**
     * The maximum response that occurs when the wheel response multiplier has value 1.0 and nonlinearResponse is in the default state of linear response.
     */
    public float getMaxResponse() {
        checkNotNull();
        return _getMaxResponse(address);
    }
    private static native float _getMaxResponse(long address);

    /**
     * The maximum response that occurs when the wheel response multiplier has value 1.0 and nonlinearResponse is in the default state of linear response.
     */
    public void setMaxResponse(float value) {
        checkNotNull();
        _setMaxResponse(address, value);
    }
    private static native void _setMaxResponse(long address, float value);

}
